/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.reflection.ReflectorException;

public final class Reflector {
    private static final String CONSTRUCTOR_METHOD_NAME = "$$CONSTRUCTOR$$";
    private static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    private HashMap classMaps = new HashMap();

    private Method _getMethod(Class targetClass, String methodName, Class[] params) throws ReflectorException {
        Map methodMap = this.getMethodMap(targetClass, methodName);
        StringBuffer key = new StringBuffer(200);
        key.append("(");
        int i = 0;
        int len = params.length;
        while (i < len) {
            key.append(params[i].getName());
            key.append(",");
            ++i;
        }
        key.append(")");
        Method method = null;
        String paramKey = key.toString();
        String string = paramKey.intern();
        synchronized (string) {
            method = (Method)methodMap.get(paramKey);
            if (method == null) {
                Method[] cands = targetClass.getMethods();
                int i2 = 0;
                int len2 = cands.length;
                while (i2 < len2) {
                    Class<?>[] types;
                    String name = cands[i2].getName();
                    if (methodName.equals(name) && params.length == (types = cands[i2].getParameterTypes()).length) {
                        int j = 0;
                        int len22 = params.length;
                        while (j < len22) {
                            if (!types[j].isAssignableFrom(params[j])) {
                                // empty if block
                            }
                            ++j;
                        }
                        method = cands[i2];
                        methodMap.put(paramKey, method);
                    }
                    ++i2;
                }
            }
        }
        return method;
    }

    public Constructor getConstructor(Class targetClass, Class[] params) throws ReflectorException {
        Map constructorMap = this.getConstructorMap(targetClass);
        StringBuffer key = new StringBuffer(200);
        key.append("(");
        int i = 0;
        int len = params.length;
        while (i < len) {
            key.append(params[i].getName());
            key.append(",");
            ++i;
        }
        if (params.length > 0) {
            key.setLength(key.length() - 1);
        }
        key.append(")");
        Constructor<?> constructor = null;
        String paramKey = key.toString();
        String string = paramKey.intern();
        synchronized (string) {
            constructor = (Constructor<?>)constructorMap.get(paramKey);
            if (constructor == null) {
                Constructor<?>[] cands = targetClass.getConstructors();
                int i2 = 0;
                int len2 = cands.length;
                while (i2 < len2) {
                    Class<?>[] types = cands[i2].getParameterTypes();
                    if (params.length == types.length) {
                        int j = 0;
                        int len22 = params.length;
                        while (j < len22) {
                            if (!types[j].isAssignableFrom(params[j])) {
                                // empty if block
                            }
                            ++j;
                        }
                        constructor = cands[i2];
                        constructorMap.put(paramKey, constructor);
                    }
                    ++i2;
                }
            }
        }
        if (constructor == null) {
            throw new ReflectorException("Error retrieving constructor object for: " + targetClass.getName() + paramKey);
        }
        return constructor;
    }

    private Map getConstructorMap(Class theClass) throws ReflectorException {
        return this.getMethodMap(theClass, CONSTRUCTOR_METHOD_NAME);
    }

    public Object getField(Object target, String fieldName) throws ReflectorException {
        return this.getField(target, fieldName, false);
    }

    public Object getField(Object target, String fieldName, boolean breakAccessibility) throws ReflectorException {
        try {
            Class<?> targetClass = target.getClass();
            Field field = targetClass.getField(fieldName);
            boolean accessibilityBroken = false;
            if (!field.isAccessible() && breakAccessibility) {
                ((AccessibleObject)field).setAccessible(true);
                accessibilityBroken = true;
            }
            Object result = field.get(target);
            if (accessibilityBroken) {
                ((AccessibleObject)field).setAccessible(false);
            }
            return result;
        }
        catch (SecurityException e) {
            throw new ReflectorException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException(e);
        }
    }

    public Method getMethod(Class targetClass, String methodName, Class[] params) throws ReflectorException {
        Method method = this._getMethod(targetClass, methodName, params);
        if (method == null) {
            throw new ReflectorException("Method: '" + methodName + "' not found in class: '" + targetClass + "'");
        }
        return method;
    }

    private Map getMethodMap(Class theClass, String methodName) throws ReflectorException {
        Map methodMap = null;
        if (theClass == null) {
            return null;
        }
        String className = theClass.getName();
        String string = className.intern();
        synchronized (string) {
            HashMap classMethods = (HashMap)this.classMaps.get(className);
            if (classMethods == null) {
                classMethods = new HashMap();
                methodMap = new HashMap();
                classMethods.put(methodName, methodMap);
                this.classMaps.put(className, classMethods);
            } else {
                String key = String.valueOf(className) + "::" + methodName;
                String string2 = key.intern();
                synchronized (string2) {
                    methodMap = (Map)classMethods.get(methodName);
                    if (methodMap == null) {
                        methodMap = new HashMap();
                        classMethods.put(methodName, methodMap);
                    }
                }
            }
        }
        return methodMap;
    }

    public Object getObjectProperty(Object target, String propertyName) throws ReflectorException {
        Class[] emptyParams;
        Class<?> targetClass;
        Method method;
        if (propertyName == null || propertyName.trim().length() < 1) {
            throw new ReflectorException("Cannot retrieve value for empty property.");
        }
        String beanAccessor = "get" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.trim().length() > 1) {
            beanAccessor = String.valueOf(beanAccessor) + propertyName.substring(1).trim();
        }
        if ((method = this._getMethod(targetClass = target.getClass(), beanAccessor, emptyParams = new Class[0])) == null) {
            method = this._getMethod(targetClass, propertyName, emptyParams);
        }
        Object returnValue = this.getField(targetClass, propertyName, true);
        if (method == null && returnValue == null) {
            throw new ReflectorException("Neither method: '" + propertyName + "' nor bean accessor: '" + beanAccessor + "' can be found for class: '" + targetClass + "', and retrieval of field: '" + propertyName + "' returned null.");
        }
        if (method != null) {
            try {
                returnValue = method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ReflectorException("Error retrieving property '" + propertyName + "' from '" + targetClass + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectorException("Error retrieving property '" + propertyName + "' from '" + targetClass + "'", e);
            }
        }
        return returnValue;
    }

    public Object getSingleton(Class theClass, Object[] initParams) throws ReflectorException {
        Class[] paramTypes = new Class[initParams.length];
        int i = 0;
        int len = initParams.length;
        while (i < len) {
            paramTypes[i] = initParams[i].getClass();
            ++i;
        }
        try {
            Method method = this.getMethod(theClass, GET_INSTANCE_METHOD_NAME, paramTypes);
            return method.invoke(null, initParams);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object getStaticField(Class targetClass, String fieldName) throws ReflectorException {
        try {
            Field field = targetClass.getField(fieldName);
            return field.get(null);
        }
        catch (SecurityException e) {
            throw new ReflectorException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException(e);
        }
    }

    public Object invoke(Object target, String methodName, Object[] params) throws ReflectorException {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        int len = params.length;
        while (i < len) {
            paramTypes[i] = params[i].getClass();
            ++i;
        }
        try {
            Method method = this.getMethod(target.getClass(), methodName, paramTypes);
            if (method == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Singleton-producing method named '" + methodName + "' not found with specified parameter classes: ");
                int i2 = 0;
                while (i2 < paramTypes.length) {
                    buffer.append(paramTypes[i2].getName());
                    buffer.append(',');
                    ++i2;
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return method.invoke(target, params);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object invokeStatic(Class targetClass, String methodName, Object[] params) throws ReflectorException {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        int len = params.length;
        while (i < len) {
            paramTypes[i] = params[i].getClass();
            ++i;
        }
        try {
            Method method = this.getMethod(targetClass, methodName, paramTypes);
            if (method == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Singleton-producing method named '" + methodName + "' not found with specified parameter classes: ");
                int i2 = 0;
                while (i2 < paramTypes.length) {
                    buffer.append(paramTypes[i2].getName());
                    buffer.append(',');
                    ++i2;
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return method.invoke(null, params);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object newInstance(Class theClass, Object[] params) throws ReflectorException {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        int len = params.length;
        while (i < len) {
            paramTypes[i] = params[i].getClass();
            ++i;
        }
        try {
            Constructor con = this.getConstructor(theClass, paramTypes);
            if (con == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Constructor not found for class: ");
                buffer.append(theClass.getName());
                buffer.append(" with specified or ancestor parameter classes: ");
                int i2 = 0;
                while (i2 < paramTypes.length) {
                    buffer.append(paramTypes[i2].getName());
                    buffer.append(',');
                    ++i2;
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return con.newInstance(params);
        }
        catch (InstantiationException ex) {
            throw new ReflectorException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }
}

