/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.CommitIdGenerationMode;
import pl.project13.maven.git.GitCommitIdExecutionException;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitProvider;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.util.PropertyManager;

public abstract class GitDataProvider
implements GitProvider {
    @NotNull
    protected final LoggerBridge log;
    protected String prefixDot;
    protected int abbrevLength;
    protected String dateFormat;
    protected String dateFormatTimeZone;
    protected GitDescribeConfig gitDescribe = new GitDescribeConfig();
    protected CommitIdGenerationMode commitIdGenerationMode;
    protected String evaluateOnCommit;
    static final Pattern GIT_SCP_FORMAT = Pattern.compile("^([a-zA-Z0-9_.+-])+@(.*)|^\\[([^\\]])+\\]:(.*)|^file:///(.*)");

    public GitDataProvider(@NotNull LoggerBridge log) {
        this.log = log;
    }

    public GitDataProvider setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
        return this;
    }

    public GitDataProvider setPrefixDot(String prefixDot) {
        this.prefixDot = prefixDot;
        return this;
    }

    public GitDataProvider setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
        return this;
    }

    public GitDataProvider setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public GitDataProvider setCommitIdGenerationMode(CommitIdGenerationMode commitIdGenerationMode) {
        this.commitIdGenerationMode = commitIdGenerationMode;
        return this;
    }

    public GitDataProvider setDateFormatTimeZone(String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
        return this;
    }

    public void loadGitData(@NotNull String evaluateOnCommit, @NotNull Properties properties) throws GitCommitIdExecutionException {
        this.evaluateOnCommit = evaluateOnCommit;
        this.init();
        this.put(properties, "build.user.name", this.getBuildAuthorName());
        this.put(properties, "build.user.email", this.getBuildAuthorEmail());
        try {
            this.prepareGitToExtractMoreDetailedRepoInformation();
            this.validateAbbrevLength(this.abbrevLength);
            this.put(properties, "branch", this.determineBranchName(System.getenv()));
            this.maybePutGitDescribe(properties);
            switch (this.commitIdGenerationMode) {
                case FULL: {
                    this.put(properties, "commit.id.full", this.getCommitId());
                    break;
                }
                case FLAT: {
                    this.put(properties, "commit.id", this.getCommitId());
                    break;
                }
                default: {
                    throw new GitCommitIdExecutionException("Unsupported commitIdGenerationMode: " + (Object)((Object)this.commitIdGenerationMode));
                }
            }
            this.put(properties, "commit.id.abbrev", this.getAbbrevCommitId());
            this.put(properties, "dirty", Boolean.toString(this.isDirty()));
            this.put(properties, "commit.user.name", this.getCommitAuthorName());
            this.put(properties, "commit.user.email", this.getCommitAuthorEmail());
            this.put(properties, "commit.message.full", this.getCommitMessageFull());
            this.put(properties, "commit.message.short", this.getCommitMessageShort());
            this.put(properties, "commit.time", this.getCommitTime());
            this.put(properties, "remote.origin.url", this.getRemoteOriginUrl());
            this.put(properties, "tags", this.getTags());
            this.put(properties, "closest.tag.name", this.getClosestTagName());
            this.put(properties, "closest.tag.commit.count", this.getClosestTagCommitCount());
        }
        finally {
            this.finalCleanUp();
        }
    }

    private void maybePutGitDescribe(@NotNull Properties properties) throws GitCommitIdExecutionException {
        boolean isGitDescribeOptOutByConfiguration;
        boolean isGitDescribeOptOutByDefault = this.gitDescribe == null;
        boolean bl = isGitDescribeOptOutByConfiguration = this.gitDescribe != null && !this.gitDescribe.isSkip();
        if (isGitDescribeOptOutByDefault || isGitDescribeOptOutByConfiguration) {
            this.put(properties, "commit.id.describe", this.getGitDescribe());
        }
    }

    void validateAbbrevLength(int abbrevLength) throws GitCommitIdExecutionException {
        if (abbrevLength < 2 || abbrevLength > 40) {
            throw new GitCommitIdExecutionException(String.format("Abbreviated commit id length must be between 2 and 40, inclusive! Was [%s]. ", abbrevLength) + "Please fix your configuration (the <abbrevLength/> element).");
        }
    }

    protected String determineBranchName(Map<String, String> env) throws GitCommitIdExecutionException {
        if (this.runningOnBuildServer(env)) {
            return this.determineBranchNameOnBuildServer(env);
        }
        return this.getBranchName();
    }

    private boolean runningOnBuildServer(Map<String, String> env) {
        return env.containsKey("HUDSON_URL") || env.containsKey("JENKINS_URL") || env.containsKey("HUDSON_HOME") || env.containsKey("JENKINS_HOME");
    }

    protected String determineBranchNameOnBuildServer(Map<String, String> env) throws GitCommitIdExecutionException {
        String environmentBasedLocalBranch = env.get("GIT_LOCAL_BRANCH");
        if (!Strings.isNullOrEmpty((String)environmentBasedLocalBranch)) {
            this.log.info("Using environment variable based branch name. GIT_LOCAL_BRANCH = {}", (Object)environmentBasedLocalBranch);
            return environmentBasedLocalBranch;
        }
        String environmentBasedBranch = env.get("GIT_BRANCH");
        if (!Strings.isNullOrEmpty((String)environmentBasedBranch)) {
            this.log.info("Using environment variable based branch name. GIT_BRANCH = {}", (Object)environmentBasedBranch);
            return environmentBasedBranch;
        }
        this.log.info("Detected that running on CI environment, but using repository branch, no GIT_BRANCH detected.");
        return this.getBranchName();
    }

    protected SimpleDateFormat getSimpleDateFormatWithTimeZone() {
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        if (this.dateFormatTimeZone != null) {
            smf.setTimeZone(TimeZone.getTimeZone(this.dateFormatTimeZone));
        }
        return smf;
    }

    protected void put(@NotNull Properties properties, String key, String value) {
        String keyWithPrefix = this.prefixDot + key;
        this.log.info("{} {}", (Object)keyWithPrefix, (Object)value);
        PropertyManager.putWithoutPrefix(properties, keyWithPrefix, value);
    }

    protected static String stripCredentialsFromOriginUrl(String gitRemoteString) throws GitCommitIdExecutionException {
        if (gitRemoteString == null) {
            return gitRemoteString;
        }
        if (GIT_SCP_FORMAT.matcher(gitRemoteString).matches()) {
            return gitRemoteString;
        }
        try {
            URI original = new URI(gitRemoteString);
            String userInfoString = original.getUserInfo();
            if (null == userInfoString) {
                return gitRemoteString;
            }
            URIBuilder b = new URIBuilder(gitRemoteString);
            String[] userInfo = userInfoString.split(":");
            b.setUserInfo(userInfo[0]);
            return b.build().toString();
        }
        catch (URISyntaxException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }
}

