/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescribeResult {
    private Optional<String> tagName = Optional.absent();
    private Optional<ObjectId> commitId = Optional.absent();
    private Optional<AbbreviatedObjectId> abbreviatedObjectId = Optional.absent();
    private int abbrev = 7;
    private int commitsAwayFromTag;
    private boolean dirty;
    private String dirtyMarker;
    private boolean forceLongFormat;
    private ObjectReader objectReader;
    public static final DescribeResult EMPTY = new DescribeResult("");

    public DescribeResult(@NotNull String tagName) {
        this(tagName, false, (Optional<String>)Optional.absent());
    }

    public DescribeResult(@NotNull ObjectReader objectReader, String tagName, int commitsAwayFromTag, @NotNull ObjectId commitId) {
        this(objectReader, tagName, commitsAwayFromTag, commitId, false, (Optional<String>)Optional.absent(), false);
    }

    public DescribeResult(@NotNull ObjectReader objectReader, @NotNull ObjectId commitId) {
        this.objectReader = objectReader;
        this.commitId = Optional.of((Object)commitId);
        this.abbreviatedObjectId = DescribeResult.createAbbreviatedCommitId(objectReader, commitId, this.abbrev);
    }

    public DescribeResult(@NotNull ObjectReader objectReader, String tagName, int commitsAwayFromTag, ObjectId commitId, boolean dirty, String dirtyMarker) {
        this(objectReader, tagName, commitsAwayFromTag, commitId, dirty, (Optional<String>)Optional.of((Object)dirtyMarker), false);
    }

    public DescribeResult(@NotNull ObjectReader objectReader, String tagName, int commitsAwayFromTag, ObjectId commitId, boolean dirty, Optional<String> dirtyMarker, boolean forceLongFormat) {
        this(objectReader, commitId, dirty, dirtyMarker);
        this.tagName = Optional.of((Object)tagName);
        this.commitsAwayFromTag = commitsAwayFromTag;
        this.forceLongFormat = forceLongFormat;
    }

    public DescribeResult(@NotNull ObjectReader objectReader, @NotNull ObjectId commitId, boolean dirty, @NotNull Optional<String> dirtyMarker) {
        this.objectReader = objectReader;
        this.commitId = Optional.of((Object)commitId);
        this.abbreviatedObjectId = DescribeResult.createAbbreviatedCommitId(objectReader, commitId, this.abbrev);
        this.dirty = dirty;
        this.dirtyMarker = (String)dirtyMarker.or((Object)"");
    }

    public DescribeResult(@NotNull String tagName, boolean dirty, @NotNull Optional<String> dirtyMarker) {
        this.tagName = Optional.of((Object)tagName);
        this.dirty = dirty;
        this.dirtyMarker = (String)dirtyMarker.or((Object)"");
    }

    @NotNull
    public DescribeResult withCommitIdAbbrev(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)String.format("The --abbrev parameter must be >= 0, but it was: [%s]", n));
        this.abbrev = n;
        this.abbreviatedObjectId = DescribeResult.createAbbreviatedCommitId(this.objectReader, (ObjectId)this.commitId.get(), this.abbrev);
        return this;
    }

    public String toString() {
        ArrayList<String> parts = this.abbrevZeroHidesCommitsPartOfDescribe() ? new ArrayList<String>(Collections.singletonList(this.tag())) : new ArrayList<String>(Arrays.asList(this.tag(), this.commitsAwayFromTag(), this.prefixedCommitId()));
        return Joiner.on((String)"-").skipNulls().join(parts) + this.dirtyMarker();
    }

    private boolean abbrevZeroHidesCommitsPartOfDescribe() {
        return this.abbrev == 0;
    }

    @Nullable
    public String commitsAwayFromTag() {
        if (this.forceLongFormat) {
            return String.valueOf(this.commitsAwayFromTag);
        }
        return this.commitsAwayFromTag == 0 ? null : String.valueOf(this.commitsAwayFromTag);
    }

    @Nullable
    public String dirtyMarker() {
        return this.dirty ? this.dirtyMarker : "";
    }

    @Nullable
    public String prefixedCommitId() {
        if (this.abbreviatedObjectId.isPresent()) {
            String name = ((AbbreviatedObjectId)this.abbreviatedObjectId.get()).name();
            return this.gPrefixedCommitId(name);
        }
        if (this.commitId.isPresent()) {
            String name = ((ObjectId)this.commitId.get()).name();
            return this.gPrefixedCommitId(name);
        }
        return null;
    }

    private String gPrefixedCommitId(String name) {
        if (this.tagName.isPresent()) {
            return "g" + name;
        }
        return name;
    }

    private static Optional<AbbreviatedObjectId> createAbbreviatedCommitId(@NotNull ObjectReader objectReader, ObjectId commitId, int requestedLength) {
        if (requestedLength < 2) {
            return Optional.absent();
        }
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)commitId, requestedLength);
            return Optional.of((Object)abbreviatedObjectId);
        }
        catch (IOException e) {
            return Optional.absent();
        }
    }

    @Nullable
    public ObjectId commitObjectId() {
        if (this.commitId.isPresent()) {
            return (ObjectId)this.commitId.get();
        }
        return null;
    }

    @Nullable
    public String tag() {
        return (String)this.tagName.orNull();
    }
}

