/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import junitparams.internal.ParameterisedTestClassRunner;
import junitparams.internal.ParametrizedTestMethodsFilter;
import junitparams.internal.TestMethod;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.validator.PublicClassValidator;

public class JUnitParamsRunner
extends BlockJUnit4ClassRunner {
    private ParametrizedTestMethodsFilter parametrizedTestMethodsFilter = new ParametrizedTestMethodsFilter(this);
    private ParameterisedTestClassRunner parameterisedRunner = new ParameterisedTestClassRunner(this.getTestClass());
    private Description description;

    public JUnitParamsRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        super.filter(filter);
        this.parametrizedTestMethodsFilter = new ParametrizedTestMethodsFilter(this, filter);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.validatePublicTestClass();
        this.validateZeroArgConstructor(errors);
        this.validateLifecycleMethods(errors);
        this.validateRules(errors);
        for (Throwable throwable : errors) {
            throwable.printStackTrace();
        }
    }

    private void validatePublicTestClass() {
        new PublicClassValidator().validateTestClass(this.getTestClass());
    }

    private void validateRules(List<Throwable> errors) {
        RuleMemberValidator.CLASS_RULE_VALIDATOR.validate(this.getTestClass(), errors);
        RuleMemberValidator.CLASS_RULE_METHOD_VALIDATOR.validate(this.getTestClass(), errors);
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.getTestClass(), errors);
        RuleMemberValidator.RULE_VALIDATOR.validate(this.getTestClass(), errors);
    }

    private void validateLifecycleMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
        this.validatePublicVoidNoArgMethods(AfterClass.class, true, errors);
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.handleIgnored(method, notifier)) {
            return;
        }
        TestMethod testMethod = this.parameterisedRunner.testMethodFor(method);
        if (this.parameterisedRunner.shouldRun(testMethod)) {
            this.parameterisedRunner.runParameterisedTest(testMethod, this.methodBlock(method), notifier);
        } else {
            this.verifyMethodCanBeRunByStandardRunner(testMethod);
            super.runChild(method, notifier);
        }
    }

    protected Description describeChild(FrameworkMethod method) {
        Description description = this.parameterisedRunner.getDescriptionFor(method);
        return description == null ? super.describeChild(method) : description;
    }

    private void verifyMethodCanBeRunByStandardRunner(TestMethod testMethod) {
        ArrayList errors = new ArrayList();
        testMethod.frameworkMethod().validatePublicVoidNoArg(false, errors);
        if (!errors.isEmpty()) {
            throw new RuntimeException((Throwable)errors.get(0));
        }
    }

    private boolean handleIgnored(FrameworkMethod method, RunNotifier notifier) {
        TestMethod testMethod = this.parameterisedRunner.testMethodFor(method);
        if (testMethod.isIgnored()) {
            notifier.fireTestIgnored(this.describeMethod(method));
        }
        return testMethod.isIgnored();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.parameterisedRunner.computeFrameworkMethods();
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement methodInvoker = this.parameterisedRunner.parameterisedMethodInvoker(method, test);
        if (methodInvoker == null) {
            methodInvoker = super.methodInvoker(method, test);
        }
        return methodInvoker;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getTestClass().getAnnotations());
            List<FrameworkMethod> resultMethods = this.getListOfMethods();
            for (FrameworkMethod method : resultMethods) {
                this.description.addChild(this.describeMethod(method));
            }
        }
        return this.description;
    }

    private List<FrameworkMethod> getListOfMethods() {
        List<FrameworkMethod> frameworkMethods = this.parameterisedRunner.returnListOfMethods();
        return this.parametrizedTestMethodsFilter.filteredMethods(frameworkMethods);
    }

    public Description describeMethod(FrameworkMethod method) {
        Description child = this.parameterisedRunner.describeParameterisedMethod(method);
        if (child == null) {
            child = this.describeChild(method);
        }
        return child;
    }

    @Deprecated
    public static Object[] $(Object ... params) {
        return params;
    }
}

