/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import junitparams.Parameters;
import junitparams.internal.parameters.toarray.ParamsToArrayConverter;
import org.junit.runners.model.FrameworkMethod;

class ParamsFromMethodCommon {
    private final FrameworkMethod frameworkMethod;

    ParamsFromMethodCommon(FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
    }

    Object[] paramsFromMethod(Class<?> sourceClass) {
        String methodAnnotation = ((Parameters)this.frameworkMethod.getAnnotation(Parameters.class)).method();
        if (methodAnnotation.isEmpty()) {
            return this.invokeMethodWithParams(this.defaultMethodName(), sourceClass);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String methodName : methodAnnotation.split(",")) {
            for (Object param : this.invokeMethodWithParams(methodName.trim(), sourceClass)) {
                result.add(param);
            }
        }
        return result.toArray();
    }

    boolean containsDefaultParametersProvidingMethod(Class<?> sourceClass) {
        return this.findMethodInTestClassHierarchy(this.defaultMethodName(), sourceClass) != null;
    }

    private String defaultMethodName() {
        return "parametersFor" + this.frameworkMethod.getName().substring(0, 1).toUpperCase() + this.frameworkMethod.getName().substring(1);
    }

    private Object[] invokeMethodWithParams(String methodName, Class<?> sourceClass) {
        Method providerMethod = this.findMethodInTestClassHierarchy(methodName, sourceClass);
        if (providerMethod == null) {
            throw new RuntimeException("Could not find method: " + methodName + " so no params were used.");
        }
        return this.invokeParamsProvidingMethod(providerMethod, sourceClass);
    }

    private Object[] invokeParamsProvidingMethod(Method provideMethod, Class<?> sourceClass) {
        try {
            Object testObject = sourceClass.newInstance();
            provideMethod.setAccessible(true);
            Object result = provideMethod.invoke(testObject, new Object[0]);
            return new ParamsToArrayConverter(this.frameworkMethod).convert(result);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The return type of: " + provideMethod.getName() + " defined in class " + sourceClass + " should be one of the following:\nObject[][], Iterable<Object[]>, Iterable<Iterable<Object>>," + " Iterator<Object[]>.\nFix it!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke method: " + provideMethod.getName() + " defined in class " + sourceClass + " so no params were used.", e);
        }
    }

    private Method findMethodInTestClassHierarchy(String methodName, Class<?> sourceClass) {
        Class<?> declaringClass = sourceClass;
        while (declaringClass.getSuperclass() != null) {
            try {
                return declaringClass.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception ignore) {
                declaringClass = declaringClass.getSuperclass();
            }
        }
        return null;
    }
}

