/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import junitparams.custom.ParametersProvider;
import junitparams.internal.annotation.CustomParametersDescriptor;
import junitparams.internal.annotation.FrameworkMethodAnnotations;
import junitparams.internal.parameters.ParametrizationStrategy;
import org.junit.runners.model.FrameworkMethod;

class ParametersFromCustomProvider
implements ParametrizationStrategy {
    private final FrameworkMethodAnnotations frameworkMethodAnnotations;

    ParametersFromCustomProvider(FrameworkMethod frameworkMethod) {
        this.frameworkMethodAnnotations = new FrameworkMethodAnnotations(frameworkMethod);
    }

    @Override
    public boolean isApplicable() {
        return this.frameworkMethodAnnotations.hasCustomParameters();
    }

    @Override
    public Object[] getParameters() {
        CustomParametersDescriptor parameters = this.frameworkMethodAnnotations.getCustomParameters();
        ParametersProvider provider = this.instantiate(parameters.provider());
        provider.initialize(parameters.annotation());
        return provider.getParameters();
    }

    private ParametersProvider instantiate(Class<? extends ParametersProvider> providerClass) {
        try {
            return providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Your Provider class must have a public no-arg constructor!", e);
        }
    }
}

