/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.commons.lang3.reflect.TypeUtils;
import pl.pojo.tester.internal.utils.GetterNotFoundException;
import pl.pojo.tester.internal.utils.SetterNotFoundException;

public final class MethodUtils {
    private MethodUtils() {
    }

    public static Method findSetterFor(Class<?> clazz, Field field) {
        return Arrays.stream(clazz.getMethods()).filter(MethodUtils.methodHasOnlyOneParameter()).filter(MethodUtils.areParameterAndFieldTypeAssignable(field)).filter(MethodUtils.returnTypeIsVoid()).filter(method -> MethodUtils.prefixMatchesSettersPrefixAndHasExpectedLength(method, field.getName())).findAny().orElseThrow(() -> new SetterNotFoundException(clazz, field));
    }

    public static Method findGetterFor(Class<?> clazz, Field field) {
        return Arrays.stream(clazz.getMethods()).filter(MethodUtils.hasZeroParameters()).filter(MethodUtils.areReturnAndFieldTypeAssignable(field)).filter(method -> MethodUtils.prefixMatchesGettersPrefixAndHasExpectedLength(method, field.getName())).findAny().orElseThrow(() -> new GetterNotFoundException(clazz, field));
    }

    private static Predicate<Method> returnTypeIsVoid() {
        return method -> method.getReturnType() == Void.TYPE;
    }

    private static Predicate<Method> areParameterAndFieldTypeAssignable(Field field) {
        return method -> TypeUtils.isAssignable(method.getParameterTypes()[0], field.getType());
    }

    private static Predicate<Method> methodHasOnlyOneParameter() {
        return method -> method.getParameterCount() == 1;
    }

    private static Predicate<Method> areReturnAndFieldTypeAssignable(Field field) {
        return method -> TypeUtils.isAssignable(method.getReturnType(), field.getType());
    }

    private static Predicate<Method> hasZeroParameters() {
        return method -> method.getParameterCount() == 0;
    }

    private static boolean prefixMatchesGettersPrefixAndHasExpectedLength(Method method, String fieldName) {
        Class<?> returnType = method.getReturnType();
        String methodName = method.getName();
        int fieldNameLength = fieldName.length();
        String upperCaseFirstLetterFieldName = MethodUtils.upperCaseFirstLetter(fieldName);
        if (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class)) {
            return methodName.startsWith("is") && methodName.equals(fieldName) || methodName.endsWith(upperCaseFirstLetterFieldName) && (methodName.startsWith("is") && methodName.length() == fieldNameLength + 2 || methodName.startsWith("has") && methodName.length() == fieldNameLength + 3 || methodName.startsWith("get") && methodName.length() == fieldNameLength + 3 || methodName.startsWith("have") && methodName.length() == fieldNameLength + 4 || methodName.startsWith("contains") && methodName.length() == fieldNameLength + 8);
        }
        return methodName.startsWith("get") && methodName.length() == fieldNameLength + 3 && methodName.endsWith(upperCaseFirstLetterFieldName);
    }

    private static boolean prefixMatchesSettersPrefixAndHasExpectedLength(Method method, String fieldName) {
        Class<?> parameterType = method.getParameterTypes()[0];
        String methodName = method.getName();
        int fieldNameLength = fieldName.length();
        String upperCaseFirstLetterFieldName = MethodUtils.upperCaseFirstLetter(fieldName);
        if ((parameterType.equals(Boolean.TYPE) || parameterType.equals(Boolean.class)) && fieldName.startsWith("is")) {
            String fieldNameWithoutPrefix = fieldName.substring(2);
            return methodName.startsWith("set") && methodName.endsWith(fieldNameWithoutPrefix);
        }
        return methodName.startsWith("set") && methodName.length() == fieldNameLength + 3 && methodName.endsWith(upperCaseFirstLetterFieldName);
    }

    private static String upperCaseFirstLetter(String string) {
        String firstLetter = string.substring(0, 1).toUpperCase();
        return firstLetter + string.substring(1, string.length());
    }
}

