/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import pl.pojo.tester.internal.GetOrSetValueException;

public final class FieldUtils {
    private static final String MODIFIERS_FIELD_NAME_IN_FIELD_CLASS = "modifiers";

    private FieldUtils() {
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(FieldUtils::isNotSynthetic).filter(FieldUtils::isNotStatic).collect(Collectors.toList());
    }

    public static List<Field> getAllFieldsExcluding(Class<?> clazz, List<String> excludedFields) {
        return FieldUtils.getAllFields(clazz).stream().filter(field -> FieldUtils.doesNotContain(field, excludedFields)).collect(Collectors.toList());
    }

    public static List<List<Field>> permutations(List<Field> fields) {
        ICombinatoricsVector vector = Factory.createVector(fields);
        Generator subSetGenerator = Factory.createSubSetGenerator((ICombinatoricsVector)vector);
        return subSetGenerator.generateAllObjects().stream().map(ICombinatoricsVector::getVector).filter(FieldUtils::excludeEmptySet).collect(Collectors.toList());
    }

    public static List<String> getAllFieldNames(Class<?> clazz) {
        return FieldUtils.getAllFields(clazz).stream().map(Field::getName).collect(Collectors.toList());
    }

    public static Object getValue(Object targetObject, Field field) {
        try {
            FieldUtils.makeModifiable(field);
            return field.get(targetObject);
        }
        catch (IllegalAccessException e) {
            throw new GetOrSetValueException(field.getName(), targetObject.getClass(), e);
        }
    }

    public static void setValue(Object targetObject, Field field, Object value) {
        try {
            FieldUtils.makeModifiable(field);
            field.set(targetObject, value);
        }
        catch (IllegalAccessException e) {
            throw new GetOrSetValueException(field.getName(), targetObject.getClass(), e);
        }
    }

    public static List<Field> getFields(Class<?> testedClass, Predicate<String> predicate) {
        return FieldUtils.getAllFields(testedClass).stream().filter(eachField -> predicate.test(eachField.getName())).collect(Collectors.toList());
    }

    public static boolean isFinal(Field field) {
        int fieldModifiers = field.getModifiers();
        return Modifier.isFinal(fieldModifiers);
    }

    public static List<Field> getSpecifiedFields(Class<?> clazz, List<String> names) {
        return names.stream().map(name -> FieldUtils.getField(clazz, name)).collect(Collectors.toList());
    }

    private static void makeModifiable(Field field) {
        Class<?> clazz = field.getClass();
        try {
            field.setAccessible(true);
            Field modifierField = clazz.getDeclaredField(MODIFIERS_FIELD_NAME_IN_FIELD_CLASS);
            modifierField.setAccessible(true);
            int modifiers = field.getModifiers() & 0xFFFFFFEF;
            modifierField.setInt(field, modifiers);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GetOrSetValueException(MODIFIERS_FIELD_NAME_IN_FIELD_CLASS, clazz, e);
        }
    }

    private static boolean excludeEmptySet(List<Field> fields) {
        return !fields.isEmpty();
    }

    private static boolean isNotSynthetic(Field field) {
        return !field.isSynthetic();
    }

    private static boolean isNotStatic(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    private static boolean doesNotContain(Field field, List<String> excludedFields) {
        return !excludedFields.contains(field.getName());
    }

    private static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new GetOrSetValueException(name, clazz, e);
        }
    }
}

