/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.preconditions;

import java.util.Arrays;
import pl.pojo.tester.internal.preconditions.BlankParameterException;
import pl.pojo.tester.internal.preconditions.NullParameterException;

public final class ParameterPreconditions {
    private ParameterPreconditions() {
    }

    public static void checkNotBlank(String parameterName, String parameterValue) {
        ParameterPreconditions.checkNotNull(parameterName, parameterValue);
        if (ParameterPreconditions.hasZeroLength(parameterValue)) {
            throw new BlankParameterException(parameterName, parameterValue);
        }
    }

    public static void checkNotBlank(String parameterName, String[] parameterValue) {
        Arrays.stream(parameterValue).forEach(each -> ParameterPreconditions.checkNotBlank(parameterName, each));
    }

    public static void checkNotNull(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new NullParameterException(parameterName);
        }
    }

    public static void checkNotNull(String parameterName, Object[] parameterValue) {
        Arrays.stream(parameterValue).forEach(each -> ParameterPreconditions.checkNotNull(parameterName, each));
    }

    private static boolean hasZeroLength(String parameterValue) {
        return parameterValue.trim().length() == 0;
    }
}

