/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.instantiator.Instantiable;
import pl.pojo.tester.internal.utils.FieldUtils;
import pl.pojo.tester.internal.utils.Permutator;

public class ObjectGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectGenerator.class);
    private final AbstractFieldValueChanger abstractFieldValueChanger;
    private final MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters;
    private final Permutator permutator;

    public ObjectGenerator(AbstractFieldValueChanger abstractFieldValueChanger, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters, Permutator permutator) {
        this.abstractFieldValueChanger = abstractFieldValueChanger;
        this.constructorParameters = constructorParameters;
        this.permutator = permutator;
    }

    public Object createNewInstance(Class<?> clazz) {
        return Instantiable.forClass(clazz, this.constructorParameters).instantiate();
    }

    public Object generateSameInstance(Object object) {
        Object newInstance = this.createNewInstance(object.getClass());
        if (!object.equals(newInstance)) {
            newInstance = this.makeThemEqual(object, newInstance);
        }
        return newInstance;
    }

    public List<Object> generateDifferentObjects(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        return this.generateDifferentObjects(0, new HashMap(), baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
    }

    private List<Object> generateDifferentObjects(int level, Map<Class<?>, List<Object>> dejaVu, ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Map<Class<?>, Predicate<String>> userDefinedClassAndFieldPredicatePairsMap = this.convertToMap(classAndFieldPredicatePairs);
        Class<?> baseClass = baseClassAndFieldPredicatePair.getClazz();
        Predicate<String> baseClassFieldPredicate = baseClassAndFieldPredicatePair.getFieldsPredicate();
        List<Field> baseClassFieldsToChange = FieldUtils.getFields(baseClass, baseClassFieldPredicate);
        userDefinedClassAndFieldPredicatePairsMap.put(baseClass, baseClassFieldPredicate);
        Map<Class<?>, List<Field>> userDefinedClassAndFieldToChangePairsMap = this.convertToClassAndFieldsToChange(userDefinedClassAndFieldPredicatePairsMap);
        List<List<Field>> baseObjectFieldsPermutations = this.permutator.permute(baseClassFieldsToChange);
        Object baseObject = this.createNewInstance(baseClass);
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(baseObject);
        this.logWithLevel(level, "Start of generating different objects for base class {}. Base object is {} -- others will be cloned from this one", baseClassAndFieldPredicatePair, baseObject);
        for (List<Field> eachBaseObjectFieldsPermutation : baseObjectFieldsPermutations) {
            Object baseObjectCopy = this.generateSameInstance(baseObject);
            HashMap nestedObjectsThatAreWaitingForSetInBaseObjectCopy = new HashMap();
            List<Object> partialResult = new ArrayList<Object>();
            for (Field field : eachBaseObjectFieldsPermutation) {
                List<Object> nestedObjectsOfFieldType;
                Class<?> permutationFieldType = field.getType();
                List<Field> nestedFieldsToChangeInFieldType = userDefinedClassAndFieldToChangePairsMap.get(permutationFieldType);
                if (nestedFieldsToChangeInFieldType == null || permutationFieldType.equals(baseClass)) {
                    Object newFieldTypeInstance = this.createNewInstance(permutationFieldType);
                    if (Objects.deepEquals(newFieldTypeInstance, FieldUtils.getValue(baseObjectCopy, field))) {
                        newFieldTypeInstance = this.abstractFieldValueChanger.increaseValue(newFieldTypeInstance);
                    }
                    FieldUtils.setValue(baseObjectCopy, field, newFieldTypeInstance);
                    continue;
                }
                if (dejaVu.containsKey(permutationFieldType)) {
                    nestedObjectsOfFieldType = new ArrayList(dejaVu.get(permutationFieldType));
                    this.logWithLevel(level, "Reusing {} objects from 'dejaVu' cache for {}", nestedObjectsOfFieldType.size(), permutationFieldType);
                } else {
                    Predicate<String> fieldPredicate = userDefinedClassAndFieldPredicatePairsMap.get(permutationFieldType);
                    List<Field> fieldClassFields = FieldUtils.getFields(permutationFieldType, fieldPredicate);
                    if (this.hasNestedFieldsToChange(fieldClassFields, userDefinedClassAndFieldPredicatePairsMap)) {
                        ClassAndFieldPredicatePair classAndFieldPredicatePair = new ClassAndFieldPredicatePair(permutationFieldType, fieldPredicate);
                        nestedObjectsOfFieldType = this.generateDifferentObjects(level + 1, dejaVu, classAndFieldPredicatePair, classAndFieldPredicatePairs);
                    } else {
                        nestedObjectsOfFieldType = this.generateDifferentObjects(permutationFieldType, fieldClassFields);
                    }
                    dejaVu.computeIfAbsent(permutationFieldType, clazz -> this.logAndPut(level, (Class<?>)clazz, nestedObjectsOfFieldType));
                }
                nestedObjectsThatAreWaitingForSetInBaseObjectCopy.put(field, nestedObjectsOfFieldType);
            }
            partialResult.add(baseObjectCopy);
            for (Map.Entry entry : nestedObjectsThatAreWaitingForSetInBaseObjectCopy.entrySet()) {
                partialResult = this.createCopiesAndFillThem(partialResult, entry);
            }
            result.addAll(partialResult);
        }
        this.logWithLevel(level, "End of generating different objects (size={}) for base class {} ", result.size(), baseClassAndFieldPredicatePair);
        return result;
    }

    private List<Object> logAndPut(int level, Class<?> clazz, List<Object> nestedObjectsOfFieldType) {
        this.logWithLevel(level, "Caching {} different objects for {} in dejaVu cache", nestedObjectsOfFieldType.size(), clazz);
        return nestedObjectsOfFieldType;
    }

    private List<Object> generateDifferentObjects(Class<?> clazz, List<Field> fieldsToChange) {
        List<List<Field>> permutationOfFields = this.permutator.permute(fieldsToChange);
        Object fieldObject = this.createNewInstance(clazz);
        List<Object> differentObjects = permutationOfFields.stream().map(fields -> this.generateInstanceWithDifferentFieldValues(fieldObject, (List<Field>)fields)).collect(Collectors.toList());
        differentObjects.add(0, fieldObject);
        return differentObjects;
    }

    private Object generateInstanceWithDifferentFieldValues(Object baseObject, List<Field> fieldsToChange) {
        Object objectToChange = this.generateSameInstance(baseObject);
        this.abstractFieldValueChanger.changeFieldsValues(baseObject, objectToChange, fieldsToChange);
        return objectToChange;
    }

    private void logWithLevel(int level, String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(message);
            LOGGER.debug(stringBuilder.toString(), args);
        }
    }

    private List<Object> createCopiesAndFillThem(List<Object> baseObjects, Map.Entry<Field, List<Object>> nestedObjectsToSet) {
        ArrayList<Object> result = new ArrayList<Object>();
        Field fieldToFill = nestedObjectsToSet.getKey();
        List<Object> objectsToFillWith = nestedObjectsToSet.getValue();
        for (Object baseObject : baseObjects) {
            List<Object> baseObjectClones = this.createCopies(baseObject, objectsToFillWith.size());
            for (int i = 0; i < baseObjectClones.size(); ++i) {
                Object baseObjectClone = baseObjectClones.get(i);
                Object valueToSet = objectsToFillWith.get(i);
                FieldUtils.setValue(baseObjectClone, fieldToFill, valueToSet);
            }
            result.addAll(baseObjectClones);
        }
        return result;
    }

    private boolean hasNestedFieldsToChange(List<Field> fields, Map<Class<?>, Predicate<String>> classes) {
        return fields.parallelStream().map(Field::getType).map(classes::get).anyMatch(Objects::nonNull);
    }

    private List<Object> createCopies(Object baseObject, int size) {
        return IntStream.range(0, size).mapToObj(each -> this.generateSameInstance(baseObject)).collect(Collectors.toList());
    }

    private Map<Class<?>, List<Field>> convertToClassAndFieldsToChange(Map<Class<?>, Predicate<String>> classAndFieldPredicatePairMap) {
        return classAndFieldPredicatePairMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> FieldUtils.getFields((Class)entry.getKey(), (Predicate)entry.getValue())));
    }

    private Map<Class<?>, Predicate<String>> convertToMap(ClassAndFieldPredicatePair[] classAndFieldPredicatePairs) {
        return Stream.of(classAndFieldPredicatePairs).collect(Collectors.toMap(ClassAndFieldPredicatePair::getClazz, ClassAndFieldPredicatePair::getFieldsPredicate));
    }

    private Object makeThemEqual(Object object, Object newInstance) {
        List<Field> allFields = this.getAllFields(object);
        for (Field field : allFields) {
            Object value = FieldUtils.getValue(object, field);
            FieldUtils.setValue(newInstance, field, value);
        }
        return newInstance;
    }

    private List<Field> getAllFields(Object object) {
        Class<?> parent = object.getClass();
        ArrayList<Field> allFields = new ArrayList<Field>();
        do {
            allFields.addAll(FieldUtils.getAllFields(parent));
        } while ((parent = parent.getSuperclass()) != null);
        return allFields;
    }
}

