/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.MultiValuedMap;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;

class JavaTypeInstantiator
extends AbstractObjectInstantiator {
    private final Map<String, Object> preparedObjects = new HashMap<String, Object>();

    JavaTypeInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz, constructorParameters);
        this.preparedObjects.put("boolean", Boolean.TRUE);
        this.preparedObjects.put("byte", (byte)-1);
        this.preparedObjects.put("char", Character.valueOf('b'));
        this.preparedObjects.put("double", -2.5);
        this.preparedObjects.put("float", Float.valueOf(-3.5f));
        this.preparedObjects.put("int", -4);
        this.preparedObjects.put("long", -5L);
        this.preparedObjects.put("short", (short)-6);
        this.preparedObjects.put(Boolean.class.getName(), Boolean.FALSE);
        this.preparedObjects.put(Byte.class.getName(), (byte)1);
        this.preparedObjects.put(Character.class.getName(), Character.valueOf('a'));
        this.preparedObjects.put(Double.class.getName(), 2.5);
        this.preparedObjects.put(Float.class.getName(), Float.valueOf(3.5f));
        this.preparedObjects.put(Integer.class.getName(), 4);
        this.preparedObjects.put(Long.class.getName(), 5L);
        this.preparedObjects.put(Short.class.getName(), (short)6);
        this.preparedObjects.put(Class.class.getName(), Object.class);
        this.preparedObjects.put(String.class.getName(), "www.pojo.pl");
        this.preparedObjects.put(UUID.class.getName(), UUID.randomUUID());
        this.preparedObjects.put(BigDecimal.class.getName(), BigDecimal.ONE);
        this.preparedObjects.put(BigInteger.class.getName(), BigInteger.ONE);
        this.preparedObjects.put(Date.class.getName(), Date.valueOf(LocalDate.now()));
        this.preparedObjects.put(java.util.Date.class.getName(), java.util.Date.from(Instant.now()));
        this.preparedObjects.put(Clock.class.getName(), Clock.systemDefaultZone());
        this.preparedObjects.put(Duration.class.getName(), Duration.ZERO);
        this.preparedObjects.put(Instant.class.getName(), Instant.now());
        this.preparedObjects.put(LocalDate.class.getName(), LocalDate.now());
        this.preparedObjects.put(LocalDateTime.class.getName(), LocalDateTime.now());
        this.preparedObjects.put(LocalTime.class.getName(), LocalTime.now());
        this.preparedObjects.put(MonthDay.class.getName(), MonthDay.now());
        this.preparedObjects.put(OffsetDateTime.class.getName(), OffsetDateTime.now());
        this.preparedObjects.put(OffsetTime.class.getName(), OffsetTime.now());
        this.preparedObjects.put(Period.class.getName(), Period.ZERO);
        this.preparedObjects.put(Year.class.getName(), Year.now());
        this.preparedObjects.put(YearMonth.class.getName(), YearMonth.now());
        this.preparedObjects.put(ZonedDateTime.class.getName(), ZonedDateTime.now());
        this.preparedObjects.put(ZoneId.class.getName(), ZoneId.systemDefault());
        this.preparedObjects.put(ZoneOffset.class.getName(), ZoneOffset.UTC);
    }

    @Override
    public Object instantiate() {
        String canonicalName = this.clazz.getCanonicalName();
        return this.preparedObjects.get(canonicalName);
    }

    @Override
    public boolean canInstantiate() {
        return this.clazz.isPrimitive() || this.preparedObjects.containsKey(this.clazz.getName());
    }
}

