/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.ArrayInstantiator;
import pl.pojo.tester.internal.instantiator.BestConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.CollectionInstantiator;
import pl.pojo.tester.internal.instantiator.DefaultConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.EnumInstantiator;
import pl.pojo.tester.internal.instantiator.JavaTypeInstantiator;
import pl.pojo.tester.internal.instantiator.ProxyInstantiator;
import pl.pojo.tester.internal.instantiator.UserDefinedConstructorInstantiator;

public final class Instantiable {
    private static final List<Class<? extends AbstractObjectInstantiator>> INSTANTIATORS = new LinkedList<Class<? extends AbstractObjectInstantiator>>();

    private Instantiable() {
    }

    static Object[] instantiateClasses(Class<?>[] classes, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        return Arrays.stream(classes).map(clazz -> Instantiable.forClass(clazz, constructorParameters)).map(AbstractObjectInstantiator::instantiate).toArray();
    }

    static AbstractObjectInstantiator forClass(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        return Instantiable.instantiateInstantiators(clazz, constructorParameters).stream().filter(AbstractObjectInstantiator::canInstantiate).findAny().get();
    }

    private static List<AbstractObjectInstantiator> instantiateInstantiators(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        ArrayList<AbstractObjectInstantiator> instantiators = new ArrayList<AbstractObjectInstantiator>();
        try {
            for (Class<? extends AbstractObjectInstantiator> instantiator : INSTANTIATORS) {
                Constructor<? extends AbstractObjectInstantiator> constructor = instantiator.getDeclaredConstructor(Class.class, MultiValuedMap.class);
                constructor.setAccessible(true);
                AbstractObjectInstantiator abstractObjectInstantiator = constructor.newInstance(clazz, constructorParameters);
                instantiators.add(abstractObjectInstantiator);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load instantiators form pl.pojo.tester.internal.instantiator package.", e);
        }
        return instantiators;
    }

    static {
        INSTANTIATORS.add(UserDefinedConstructorInstantiator.class);
        INSTANTIATORS.add(JavaTypeInstantiator.class);
        INSTANTIATORS.add(CollectionInstantiator.class);
        INSTANTIATORS.add(DefaultConstructorInstantiator.class);
        INSTANTIATORS.add(EnumInstantiator.class);
        INSTANTIATORS.add(ArrayInstantiator.class);
        INSTANTIATORS.add(ProxyInstantiator.class);
        INSTANTIATORS.add(BestConstructorInstantiator.class);
    }
}

