/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.Instantiable;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;
import pl.pojo.tester.internal.utils.CollectionUtils;

abstract class AbstractMultiConstructorInstantiator
extends AbstractObjectInstantiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMultiConstructorInstantiator.class);

    AbstractMultiConstructorInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz, constructorParameters);
    }

    protected Object instantiateUsingUserParameters() {
        Collection userConstructorParameters = this.constructorParameters.get((Object)this.clazz);
        if (this.userDefinedOwnParametersForThisClass(userConstructorParameters)) {
            Object result = this.tryToInstantiateUsing(userConstructorParameters);
            if (result != null) {
                return result;
            }
            LOGGER.warn("Could not instantiate class {} with user defined parameters. Trying create instance finding best constructor", (Object)this.clazz);
        }
        return null;
    }

    private boolean userDefinedOwnParametersForThisClass(Collection<ConstructorParameters> userConstructorParameters) {
        return CollectionUtils.isNotEmpty(userConstructorParameters);
    }

    private Object tryToInstantiateUsing(Collection<ConstructorParameters> userConstructorParameters) {
        for (ConstructorParameters param : userConstructorParameters) {
            Class<?>[] parameterTypes = param.getParametersTypes();
            try {
                Object[] parameters = param.getParameters();
                if (this.isInnerClass()) {
                    parameterTypes = this.putEnclosingClassAsFirstParameterType(this.clazz.getEnclosingClass(), parameterTypes);
                    Object enclosingClassInstance = this.instantiateEnclosingClass();
                    parameters = this.putEnclosingClassInstanceAsFirstParameter(enclosingClassInstance, parameters);
                }
                return this.createObjectFromArgsConstructor(parameterTypes, parameters);
            }
            catch (ObjectInstantiationException e) {
                LOGGER.debug("ObjectInstantiationException:", (Throwable)e);
            }
        }
        return null;
    }

    protected Object createFindingBestConstructor() {
        Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
        return Arrays.stream(constructors).map(this::createObjectFromConstructor).filter(Objects::nonNull).findAny().orElseThrow(this::createObjectInstantiationException);
    }

    protected abstract Object createObjectFromArgsConstructor(Class<?>[] var1, Object[] var2);

    protected abstract Object createObjectFromNoArgsConstructor(Constructor<?> var1);

    protected abstract ObjectInstantiationException createObjectInstantiationException();

    private Object instantiateEnclosingClass() {
        Class<?> enclosingClass = this.clazz.getEnclosingClass();
        return Instantiable.forClass(enclosingClass, this.constructorParameters).instantiate();
    }

    private Class[] putEnclosingClassAsFirstParameterType(Class<?> enclosingClass, Class<?>[] constructorParametersTypes) {
        return (Class[])Stream.concat(Stream.of(enclosingClass), Arrays.stream(constructorParametersTypes)).toArray(Class[]::new);
    }

    private boolean isInnerClass() {
        return this.clazz.getEnclosingClass() != null && !Modifier.isStatic(this.clazz.getModifiers());
    }

    private Object[] putEnclosingClassInstanceAsFirstParameter(Object enclosingClassInstance, Object[] arguments) {
        return Stream.concat(Stream.of(enclosingClassInstance), Arrays.stream(arguments)).toArray(Object[]::new);
    }

    private Object createObjectFromConstructor(Constructor<?> constructor) {
        this.makeAccessible(constructor);
        if (constructor.getParameterCount() == 0) {
            return this.createObjectFromNoArgsConstructor(constructor);
        }
        try {
            Object[] parameters = Instantiable.instantiateClasses(constructor.getParameterTypes(), this.constructorParameters);
            return this.createObjectFromArgsConstructor(constructor.getParameterTypes(), parameters);
        }
        catch (Exception e) {
            LOGGER.debug("Exception:", (Throwable)e);
            return null;
        }
    }

    private void makeAccessible(Constructor<?> constructor) {
        constructor.setAccessible(true);
    }
}

