/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.field.primitive;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.field.primitive.BooleanValueChanger;
import pl.pojo.tester.internal.field.primitive.ByteValueChanger;
import pl.pojo.tester.internal.field.primitive.CharacterValueChanger;
import pl.pojo.tester.internal.field.primitive.DoubleValueChanger;
import pl.pojo.tester.internal.field.primitive.FloatValueChanger;
import pl.pojo.tester.internal.field.primitive.IntegerValueChanger;
import pl.pojo.tester.internal.field.primitive.LongValueChanger;
import pl.pojo.tester.internal.field.primitive.ShortValueChanger;
import pl.pojo.tester.internal.utils.CollectionUtils;
import pl.pojo.tester.internal.utils.FieldUtils;

public abstract class AbstractPrimitiveValueChanger<T>
extends AbstractFieldValueChanger<T> {
    public static final AbstractFieldValueChanger INSTANCE = new BooleanValueChanger().attachNext(new ByteValueChanger()).attachNext(new CharacterValueChanger()).attachNext(new DoubleValueChanger()).attachNext(new IntegerValueChanger()).attachNext(new LongValueChanger()).attachNext(new ShortValueChanger()).attachNext(new FloatValueChanger());
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPrimitiveValueChanger.class);
    private static final List<Class<?>> PRIMITIVE_CLASSES = CollectionUtils.asList(Float.class, Integer.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Boolean.class, Character.class);
    private static final String FIELD_WITH_PRIMITIVE_CLASS_REFERENCE = "TYPE";

    @Override
    protected T increaseValue(T value, Class<?> type) {
        return this.increase(value);
    }

    protected abstract T increase(T var1);

    @Override
    protected boolean canChange(Class<?> type) {
        return this.isPrimitive(type) && this.isCompatibleWithPrimitive(type) || this.isWrappedPrimitive(type) && this.isCompatibleWithWrappedPrimitive(type);
    }

    private boolean isPrimitive(Class<?> type) {
        return type.isPrimitive();
    }

    private boolean isCompatibleWithPrimitive(Class<?> type) {
        try {
            return FieldUtils.getValue(null, this.getGenericTypeClass().getField(FIELD_WITH_PRIMITIVE_CLASS_REFERENCE)).equals(type);
        }
        catch (NoSuchFieldException e) {
            LOGGER.debug("NoSuchFieldException:", (Throwable)e);
            return false;
        }
    }

    private boolean isWrappedPrimitive(Class<?> type) {
        return PRIMITIVE_CLASSES.contains(type);
    }

    private boolean isCompatibleWithWrappedPrimitive(Class<?> type) {
        try {
            Object fieldPrimitiveType = FieldUtils.getValue(null, type.getField(FIELD_WITH_PRIMITIVE_CLASS_REFERENCE));
            return FieldUtils.getValue(null, this.getGenericTypeClass().getField(FIELD_WITH_PRIMITIVE_CLASS_REFERENCE)).equals(fieldPrimitiveType);
        }
        catch (NoSuchFieldException e) {
            LOGGER.debug("NoSuchFieldException:", (Throwable)e);
            return false;
        }
    }
}

