/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.field;

import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.field.ImpossibleEnumValueChangeException;

class EnumValueChanger
extends AbstractFieldValueChanger<Enum> {
    EnumValueChanger() {
    }

    @Override
    protected boolean canChange(Class<?> type) {
        return type.isEnum();
    }

    @Override
    protected Enum increaseValue(Enum value, Class<?> type) {
        if (value == null) {
            return this.firstValue(type);
        }
        return this.findDifferentValue(value, type);
    }

    private Enum findDifferentValue(Enum value, Class<?> type) {
        Enum[] enumConstants;
        for (Enum enumConstant : enumConstants = (Enum[])type.getEnumConstants()) {
            if (!this.areDifferentValues(value, enumConstant)) continue;
            return enumConstant;
        }
        return null;
    }

    private Enum firstValue(Class<?> type) {
        ?[] enumConstants = type.getEnumConstants();
        if (enumConstants.length == 0) {
            throw new ImpossibleEnumValueChangeException(type);
        }
        return (Enum)enumConstants[0];
    }
}

