/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.setter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import pl.pojo.tester.internal.GetOrSetValueException;
import pl.pojo.tester.internal.assertion.setter.SetterAssertionError;
import pl.pojo.tester.internal.utils.FieldUtils;

public class SetterAssertions {
    private final Object objectUnderAssert;
    private final Class<?> classUnderTest;

    public SetterAssertions(Object objectUnderAssert) {
        this.objectUnderAssert = objectUnderAssert;
        this.classUnderTest = objectUnderAssert.getClass();
    }

    public void willSetValueOnField(Method setter, Field field, Object expectedValue) {
        try {
            setter.setAccessible(true);
            setter.invoke(this.objectUnderAssert, expectedValue);
            Object value = FieldUtils.getValue(this.objectUnderAssert, field);
            boolean result = Objects.deepEquals(value, expectedValue);
            this.checkResult(result, new SetterAssertionError(this.classUnderTest, field, expectedValue, value));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GetOrSetValueException(field.getName(), this.classUnderTest, e);
        }
    }

    private void checkResult(boolean pass, SetterAssertionError errorToThrow) {
        if (!pass) {
            throw errorToThrow;
        }
    }
}

