/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api.assertion;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.api.assertion.AbstractAssertion;

class SingleClassAssertion
extends AbstractAssertion {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleClassAssertion.class);
    private final ClassAndFieldPredicatePair baseClassAndFieldPredicatePair;
    private final ClassAndFieldPredicatePair[] classAndFieldPredicatePairs;

    SingleClassAssertion(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair[] classAndFieldPredicatePairs) {
        this.baseClassAndFieldPredicatePair = baseClassAndFieldPredicatePair;
        this.classAndFieldPredicatePairs = Arrays.copyOf(classAndFieldPredicatePairs, classAndFieldPredicatePairs.length);
    }

    @Override
    protected void runAssertions() {
        this.logTestersAndClasses(LOGGER, new ClassAndFieldPredicatePair[0]);
        this.testers.forEach(tester -> tester.test(this.baseClassAndFieldPredicatePair, this.classAndFieldPredicatePairs));
    }

    @Override
    protected void logTestersAndClasses(Logger logger, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        if (LOGGER.isDebugEnabled()) {
            ClassAndFieldPredicatePair[] classes = new ClassAndFieldPredicatePair[this.classAndFieldPredicatePairs.length + 1];
            classes[0] = this.baseClassAndFieldPredicatePair;
            System.arraycopy(this.classAndFieldPredicatePairs, 0, classes, 1, classes.length - 1);
            super.logTestersAndClasses(LOGGER, classes);
        }
    }
}

