/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.internal.GetOrSetValueException;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.tester.AbstractTester;
import pl.pojo.tester.internal.utils.FieldUtils;
import pl.pojo.tester.internal.utils.MethodUtils;

public class SetterTester
extends AbstractTester {
    public SetterTester() {
    }

    public SetterTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        super(abstractFieldValueChanger);
    }

    @Override
    public void test(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Class<?> testedClass = baseClassAndFieldPredicatePair.getClazz();
        List<Field> fields = FieldUtils.getFields(testedClass, baseClassAndFieldPredicatePair.getFieldsPredicate());
        List<SetterAndFieldPair> setterAndFieldPairs = this.findSetterAndGetterPairsForFields(testedClass, fields);
        Object instance = this.objectGenerator.createNewInstance(testedClass);
        setterAndFieldPairs.forEach(eachPair -> this.testSetterAndGetter((SetterAndFieldPair)eachPair, instance));
    }

    private void testSetterAndGetter(SetterAndFieldPair eachPair, Object instance) {
        Method setter = eachPair.getSetter();
        Field field = eachPair.getField();
        Class<?> fieldType = field.getType();
        Object newValue = this.objectGenerator.createNewInstance(fieldType);
        try {
            this.testAssertions.assertThatSetMethodFor(instance).willSetValueOnField(setter, field, newValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GetOrSetValueException(field.getName(), instance.getClass(), e);
        }
    }

    private List<SetterAndFieldPair> findSetterAndGetterPairsForFields(Class<?> testedClass, List<Field> fields) {
        return fields.stream().map(fieldName -> this.findSetterAndGetterPairForField(testedClass, (Field)fieldName)).collect(Collectors.toList());
    }

    private SetterAndFieldPair findSetterAndGetterPairForField(Class<?> testedClass, Field field) {
        Method setter = MethodUtils.findSetterFor(testedClass, field);
        return new SetterAndFieldPair(setter, field);
    }

    private class SetterAndFieldPair {
        private Method setter;
        private Field field;

        public Method getSetter() {
            return this.setter;
        }

        public Field getField() {
            return this.field;
        }

        @ConstructorProperties(value={"setter", "field"})
        public SetterAndFieldPair(Method setter, Field field) {
            this.setter = setter;
            this.field = field;
        }
    }
}

