/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.tester.AbstractTester;

public class EqualsTester
extends AbstractTester {
    public EqualsTester() {
    }

    public EqualsTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        super(abstractFieldValueChanger);
    }

    @Override
    public void test(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Class<?> testedClass = baseClassAndFieldPredicatePair.getClazz();
        Object instance = this.objectGenerator.createNewInstance(testedClass);
        this.shouldEqualSameInstance(instance);
        this.shouldEqualSameInstanceFewTimes(instance);
        this.shouldEqualDifferentInstance(instance);
        this.shouldEqualObjectCifObjectBisEqualToObjectAndC(instance);
        this.shouldNotEqualNull(instance);
        this.shouldNotEqualDifferentType(instance);
        this.shouldNotEqualWithGivenFields(baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
        this.shouldEqualWithInvertedGivenFields(baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
    }

    private void shouldEqualSameInstance(Object object) {
        this.testAssertions.assertThatEqualsMethodFor(object).isReflexive();
    }

    private void shouldEqualSameInstanceFewTimes(Object object) {
        this.testAssertions.assertThatEqualsMethodFor(object).isConsistent();
    }

    private void shouldEqualDifferentInstance(Object object) {
        Object otherObject = this.objectGenerator.generateSameInstance(object);
        this.testAssertions.assertThatEqualsMethodFor(object).isSymmetric(otherObject);
    }

    private void shouldEqualObjectCifObjectBisEqualToObjectAndC(Object object) {
        Object b = this.objectGenerator.generateSameInstance(object);
        Object c = this.objectGenerator.generateSameInstance(object);
        this.testAssertions.assertThatEqualsMethodFor(object).isTransitive(b, c);
    }

    private void shouldNotEqualNull(Object object) {
        this.testAssertions.assertThatEqualsMethodFor(object).isNotEqualToNull();
    }

    private void shouldNotEqualDifferentType(Object object) {
        EqualsTester objectToCompare = this;
        this.testAssertions.assertThatEqualsMethodFor(object).isNotEqualToObjectWithDifferentType(objectToCompare);
    }

    private void shouldNotEqualWithGivenFields(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        List<Object> differentObjects = this.objectGenerator.generateDifferentObjects(baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
        Object firstObject = differentObjects.remove(0);
        differentObjects.forEach(this.assertIsNotEqualTo(firstObject));
    }

    private Consumer<Object> assertIsNotEqualTo(Object object) {
        return eachDifferentObject -> this.testAssertions.assertThatEqualsMethodFor(object).isNotEqualTo(eachDifferentObject);
    }

    private void shouldEqualWithInvertedGivenFields(ClassAndFieldPredicatePair base, ClassAndFieldPredicatePair ... nested) {
        ClassAndFieldPredicatePair baseWithInvertedFields = this.invertIncludedFields(base);
        List<Object> differentObjects = this.objectGenerator.generateDifferentObjects(baseWithInvertedFields, nested);
        Object firstObject = differentObjects.remove(0);
        differentObjects.forEach(this.assertIsEqualTo(firstObject));
    }

    private ClassAndFieldPredicatePair invertIncludedFields(ClassAndFieldPredicatePair base) {
        Class<?> clazz = base.getClazz();
        Predicate<String> excludedFields = base.getFieldsPredicate().negate();
        return new ClassAndFieldPredicatePair(clazz, excludedFields);
    }

    private Consumer<Object> assertIsEqualTo(Object object) {
        return eachDifferentObject -> this.testAssertions.assertThatEqualsMethodFor(object).isEqualTo(eachDifferentObject);
    }
}

