/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.tester.AbstractTester;

public class ConstructorTester
extends AbstractTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstructorTester.class);

    public ConstructorTester() {
    }

    public ConstructorTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        super(abstractFieldValueChanger);
    }

    @Override
    public void test(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Class<?> testedClass = baseClassAndFieldPredicatePair.getClazz();
        List<Constructor<?>> declaredConstructors = this.getNotSyntheticConstructorFromClass(testedClass);
        declaredConstructors.forEach(this::tryInstantiate);
    }

    private List<Constructor<?>> getNotSyntheticConstructorFromClass(Class<?> testedClass) {
        return Arrays.stream(testedClass.getDeclaredConstructors()).filter(this::isNotSynthetic).collect(Collectors.toList());
    }

    private boolean isNotSynthetic(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }

    private void tryInstantiate(Constructor<?> constructor) {
        Object[] parameters;
        Predicate<ConstructorParameters> matchingConstructorParameterTypes = ctr -> ctr.matches(constructor.getParameterTypes());
        if (this.constructorParametersAreProvided(constructor)) {
            Collection<ConstructorParameters> constructorParameters = this.getConstructorParameters(constructor);
            parameters = constructorParameters.stream().filter(matchingConstructorParameterTypes).map(ConstructorParameters::getConstructorParameters).findFirst().orElseGet(() -> this.logAndTryToCreateOwnParameters(constructor));
        } else {
            parameters = this.createConstructorParameters(constructor);
        }
        this.testAssertions.assertThatConstructor(constructor).willInstantiateClassUsing(parameters);
    }

    private Object[] logAndTryToCreateOwnParameters(Constructor<?> constructor) {
        LOGGER.warn(String.format("Class '%s' could not be created by constructor '%s' and any user defined parameters.", constructor.getDeclaringClass(), constructor));
        return this.createConstructorParameters(constructor);
    }

    private Collection<ConstructorParameters> getConstructorParameters(Constructor<?> constructor) {
        return this.getConstructorParameters().get(constructor.getDeclaringClass());
    }

    private boolean constructorParametersAreProvided(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        return this.getConstructorParameters().containsKey(declaringClass);
    }

    private Object[] createConstructorParameters(Constructor<?> constructor) {
        return Arrays.stream(constructor.getParameterTypes()).map(this.objectGenerator::createNewInstance).toArray();
    }
}

