/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.api.FieldPredicate;
import pl.pojo.tester.internal.assertion.TestAssertions;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.field.DefaultFieldValueChanger;
import pl.pojo.tester.internal.instantiator.ObjectGenerator;

public abstract class AbstractTester {
    final TestAssertions testAssertions = new TestAssertions();
    ObjectGenerator objectGenerator;
    private MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters = new ArrayListValuedHashMap();
    private AbstractFieldValueChanger fieldValuesChanger = DefaultFieldValueChanger.INSTANCE;

    public AbstractTester() {
        this(DefaultFieldValueChanger.INSTANCE);
    }

    public AbstractTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        this.objectGenerator = new ObjectGenerator(abstractFieldValueChanger, this.constructorParameters);
    }

    public void test(Class<?> clazz) {
        Predicate<String> predicateAcceptingAllFields = FieldPredicate.includeAllFields(clazz);
        this.test(clazz, predicateAcceptingAllFields);
    }

    public void test(Class<?> clazz, Predicate<String> fieldPredicate) {
        ClassAndFieldPredicatePair classAndFieldPredicatePair = new ClassAndFieldPredicatePair(clazz, fieldPredicate);
        this.test(classAndFieldPredicatePair, new ClassAndFieldPredicatePair[0]);
    }

    public abstract void test(ClassAndFieldPredicatePair var1, ClassAndFieldPredicatePair ... var2);

    public void testAll(Class ... classes) {
        ClassAndFieldPredicatePair[] classesAndFieldPredicatesPairs = (ClassAndFieldPredicatePair[])Arrays.stream(classes).map(ClassAndFieldPredicatePair::new).toArray(ClassAndFieldPredicatePair[]::new);
        this.testAll(classesAndFieldPredicatesPairs);
    }

    public void testAll(ClassAndFieldPredicatePair ... classesAndFieldPredicatesPairs) {
        List<ClassAndFieldPredicatePair> classAndFieldPredicatePairs = Arrays.asList(classesAndFieldPredicatesPairs);
        classAndFieldPredicatePairs.forEach(base -> this.test((ClassAndFieldPredicatePair)base, classesAndFieldPredicatesPairs));
    }

    public void setFieldValuesChanger(AbstractFieldValueChanger fieldValuesChanger) {
        this.fieldValuesChanger = fieldValuesChanger;
        this.objectGenerator = new ObjectGenerator(fieldValuesChanger, this.constructorParameters);
    }

    public void setUserDefinedConstructors(MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        this.constructorParameters = constructorParameters;
        this.objectGenerator = new ObjectGenerator(this.fieldValuesChanger, constructorParameters);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractTester that = (AbstractTester)otherObject;
        return new EqualsBuilder().append((Object)this.objectGenerator, (Object)that.objectGenerator).append((Object)this.testAssertions, (Object)that.testAssertions).append(this.constructorParameters, that.constructorParameters).append((Object)this.fieldValuesChanger, (Object)that.fieldValuesChanger).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.objectGenerator).append((Object)this.testAssertions).append(this.constructorParameters).append((Object)this.fieldValuesChanger).toHashCode();
    }

    protected MultiValuedMap<Class<?>, ConstructorParameters> getConstructorParameters() {
        return this.constructorParameters;
    }
}

