/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.Instantiable;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;

class UserDefinedConstructorInstantiator
extends AbstractObjectInstantiator {
    private final MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters;

    UserDefinedConstructorInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz);
        this.constructorParameters = constructorParameters;
    }

    @Override
    public Object instantiate() {
        return this.constructorParameters.get((Object)this.clazz).stream().map(this::createObjectUsingConstructorParameters).filter(Objects::nonNull).findAny().orElseThrow(this::createObjectInstantiationException);
    }

    private ObjectInstantiationException createObjectInstantiationException() {
        return new ObjectInstantiationException(this.clazz, "Could not instantiate object by any user defined constructor types and parameters.");
    }

    private Object createObjectUsingConstructorParameters(ConstructorParameters constructorParameters) {
        try {
            Class<?>[] constructorParametersTypes = constructorParameters.getConstructorParametersTypes();
            Object[] arguments = constructorParameters.getConstructorParameters();
            if (this.isInnerClass()) {
                constructorParametersTypes = this.putEnclosingClassAsFirstParameterType(this.clazz.getEnclosingClass(), constructorParametersTypes);
                Object enclosingClassInstance = this.instantiateEnclosingClass();
                arguments = this.putEnclosingClassInstanceAsFirstParameter(enclosingClassInstance, arguments);
            }
            Constructor constructor = this.clazz.getDeclaredConstructor(constructorParametersTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Object instantiateEnclosingClass() {
        Class<?> enclosingClass = this.clazz.getEnclosingClass();
        return Instantiable.forClass(enclosingClass, this.constructorParameters).instantiate();
    }

    private Object[] putEnclosingClassInstanceAsFirstParameter(Object enclosingClassInstance, Object[] arguments) {
        return Stream.concat(Stream.of(enclosingClassInstance), Arrays.stream(arguments)).toArray(Object[]::new);
    }

    private Class[] putEnclosingClassAsFirstParameterType(Class<?> enclosingClass, Class<?>[] constructorParametersTypes) {
        return (Class[])Stream.concat(Stream.of(enclosingClass), Arrays.stream(constructorParametersTypes)).toArray(Class[]::new);
    }

    private boolean isInnerClass() {
        return this.clazz.getEnclosingClass() != null && !Modifier.isStatic(this.clazz.getModifiers());
    }
}

