/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.util.proxy.ProxyFactory;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;

class ProxyInstantiator
extends AbstractObjectInstantiator {
    private final ProxyFactory proxyFactory = new ProxyFactory();

    ProxyInstantiator(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public Object instantiate() {
        if (this.clazz.isAnnotation() || this.clazz.isInterface()) {
            return this.proxyByJava();
        }
        return this.proxyByJavassist();
    }

    private Object proxyByJava() {
        return Proxy.newProxyInstance(this.clazz.getClassLoader(), new Class[]{this.clazz}, this::createInvocationHandler);
    }

    private Object proxyByJavassist() {
        try {
            this.proxyFactory.setSuperclass(this.clazz);
            return this.proxyFactory.create(new Class[0], (Object[])new Class[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ObjectInstantiationException(this.clazz, e.getMessage(), e);
        }
    }

    private Object createInvocationHandler(Object proxy, Method method, Object[] args) {
        try {
            method.setAccessible(true);
            return method.invoke(proxy, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class)) {
                return true;
            }
            if (returnType.equals(String.class)) {
                return "string";
            }
            return 0;
        }
    }
}

