/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.ArrayInstantiator;
import pl.pojo.tester.internal.instantiator.BestConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.CollectionInstantiator;
import pl.pojo.tester.internal.instantiator.DefaultConstructorInstantiator;
import pl.pojo.tester.internal.instantiator.EnumInstantiator;
import pl.pojo.tester.internal.instantiator.PrimitiveInstantiator;
import pl.pojo.tester.internal.instantiator.ProxyInstantiator;
import pl.pojo.tester.internal.instantiator.StringClassInstantiator;
import pl.pojo.tester.internal.instantiator.UserDefinedConstructorInstantiator;

public final class Instantiable {
    private Instantiable() {
    }

    static AbstractObjectInstantiator forClass(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        if (Instantiable.userDefinedConstructorParametersFor(clazz, constructorParameters)) {
            return new UserDefinedConstructorInstantiator(clazz, constructorParameters);
        }
        if (Instantiable.isStringClass(clazz)) {
            return new StringClassInstantiator();
        }
        if (Instantiable.isKindOfCollectionClass(clazz)) {
            return new CollectionInstantiator(clazz);
        }
        if (Instantiable.canBeCreatedByDefaultConstructor(clazz)) {
            return new DefaultConstructorInstantiator(clazz);
        }
        if (Instantiable.isPrimitiveOrWrapper(clazz)) {
            return new PrimitiveInstantiator(clazz);
        }
        if (clazz.isEnum()) {
            return new EnumInstantiator(clazz);
        }
        if (clazz.isArray()) {
            return new ArrayInstantiator(clazz);
        }
        if (Instantiable.qualifiesForProxy(clazz)) {
            return new ProxyInstantiator(clazz);
        }
        return new BestConstructorInstantiator(clazz, constructorParameters);
    }

    private static boolean isKindOfCollectionClass(Class<?> clazz) {
        return Iterator.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz);
    }

    private static boolean userDefinedConstructorParametersFor(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        return constructorParameters.containsKey(clazz);
    }

    private static boolean isStringClass(Class<?> clazz) {
        return clazz.equals(String.class);
    }

    private static boolean qualifiesForProxy(Class<?> clazz) {
        return clazz.isInterface() || clazz.isAnnotation() || Modifier.isAbstract(clazz.getModifiers());
    }

    private static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || Instantiable.isWrapper(clazz);
    }

    private static boolean isWrapper(Class<?> clazz) {
        return clazz == Double.class || clazz == Float.class || clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Character.class || clazz == Byte.class || clazz == Boolean.class;
    }

    private static boolean canBeCreatedByDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        return !Instantiable.qualifiesForProxy(clazz) && Arrays.stream(constructors).filter(Instantiable::isNoArgs).anyMatch(Instantiable::isPublic);
    }

    private static boolean isPublic(Constructor<?> constructor) {
        return (constructor.getModifiers() & 1) != 0;
    }

    private static boolean isNoArgs(Constructor<?> constructor) {
        return constructor.getParameterCount() == 0;
    }
}

