/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.instantiator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.collections4.MultiValuedMap;
import pl.pojo.tester.api.ConstructorParameters;
import pl.pojo.tester.internal.instantiator.AbstractObjectInstantiator;
import pl.pojo.tester.internal.instantiator.Instantiable;
import pl.pojo.tester.internal.instantiator.ObjectInstantiationException;

class BestConstructorInstantiator
extends AbstractObjectInstantiator {
    private final MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters;

    BestConstructorInstantiator(Class<?> clazz, MultiValuedMap<Class<?>, ConstructorParameters> constructorParameters) {
        super(clazz);
        this.constructorParameters = constructorParameters;
    }

    @Override
    public Object instantiate() {
        return this.createFindingBestConstructor(this.clazz);
    }

    private Object createFindingBestConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        return Arrays.stream(constructors).map(this::createObjectFromConstructor).filter(Objects::nonNull).findAny().orElseThrow(this::createObjectInstantiationException);
    }

    private ObjectInstantiationException createObjectInstantiationException() {
        return new ObjectInstantiationException(this.clazz, "Class could not be created by any constructor.");
    }

    private Object createObjectFromConstructor(Constructor<?> constructor) {
        this.makeAccessible(constructor);
        if (constructor.getParameterCount() == 0) {
            return this.createObjectFromNoArgsConstructor(constructor);
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        try {
            Object[] parameters = Arrays.stream(parameterTypes).map(this::instantiateParameter).toArray();
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException | ObjectInstantiationException e) {
            return null;
        }
    }

    private Object instantiateParameter(Class<?> clazz) {
        return Instantiable.forClass(clazz, this.constructorParameters).instantiate();
    }

    private Object createObjectFromNoArgsConstructor(Constructor<?> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    private void makeAccessible(Constructor<?> constructor) {
        constructor.setAccessible(true);
    }
}

