/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.tostring;

import org.apache.commons.lang3.ObjectUtils;
import pl.pojo.tester.internal.assertion.tostring.ContainsToStringAssertionError;
import pl.pojo.tester.internal.assertion.tostring.NotContainToStringAssertionError;
import pl.pojo.tester.internal.assertion.tostring.ToStringAssertionError;

public class ToStringAssertions {
    private final Object objectUnderAssert;
    private final Class<?> classUnderTest;

    public ToStringAssertions(Object objectUnderAssert) {
        this.objectUnderAssert = objectUnderAssert;
        this.classUnderTest = objectUnderAssert.getClass();
    }

    public void contains(String fieldName, Object value) {
        String stringValue = fieldName + "=" + this.getStringOf(value);
        String toString = this.objectUnderAssert.toString();
        boolean result = toString.contains(stringValue);
        this.checkResult(result, new ContainsToStringAssertionError(this.classUnderTest, stringValue, toString));
    }

    public void doestNotContain(String fieldName, Object value) {
        String stringValue = fieldName + "=" + this.getStringOf(value);
        String toString = this.objectUnderAssert.toString();
        boolean result = toString.contains(stringValue);
        this.checkResult(!result, new NotContainToStringAssertionError(this.classUnderTest, stringValue, toString));
    }

    private String getStringOf(Object value) {
        Object notNullObject = ObjectUtils.defaultIfNull((Object)value, (Object)"");
        return notNullObject.toString();
    }

    private void checkResult(boolean pass, ToStringAssertionError errorToThrow) {
        if (!pass) {
            throw errorToThrow;
        }
    }
}

