/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.setter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import pl.pojo.tester.internal.assertion.setter.SetterAssertionError;
import pl.pojo.tester.internal.utils.FieldUtils;

public class SetterAssertions {
    private final Object objectUnderAssert;
    private final Class<?> classUnderTest;

    public SetterAssertions(Object objectUnderAssert) {
        this.objectUnderAssert = objectUnderAssert;
        this.classUnderTest = objectUnderAssert.getClass();
    }

    public void willSetValueOnField(Method setter, Field field, Object expectedValue) throws IllegalAccessException, InvocationTargetException {
        setter.setAccessible(true);
        setter.invoke(this.objectUnderAssert, expectedValue);
        Object value = FieldUtils.getValue(this.objectUnderAssert, field);
        boolean result = Objects.equals(value, expectedValue);
        this.checkResult(result, new SetterAssertionError(this.classUnderTest, field, expectedValue, value));
    }

    private void checkResult(boolean pass, SetterAssertionError errorToThrow) {
        if (!pass) {
            throw errorToThrow;
        }
    }
}

