/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.setter;

import java.lang.reflect.Field;
import pl.pojo.tester.internal.assertion.AssertionError;

class SetterAssertionError
extends AssertionError {
    private static final String CONSTRAINT_SETTER = "The setter method for field '%s' should set field value.\nCurrent implementation does not set the value.\nExpected value:\n%s\nbut was:\n%s";
    private final Field field;
    private final Object expectedValue;
    private final Object currentValue;

    SetterAssertionError(Class<?> testedCass, Field field, Object expectedValue, Object currentValue) {
        super(testedCass);
        this.field = field;
        this.expectedValue = expectedValue;
        this.currentValue = currentValue;
    }

    @Override
    protected String getDetailedMessage() {
        return String.format(CONSTRAINT_SETTER, this.field, this.expectedValue, this.currentValue);
    }

    @Override
    protected String getErrorPrefix() {
        return String.format("Class %s has bad 'setter' method implementation.", this.testedCass.getCanonicalName());
    }
}

