/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.getter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import pl.pojo.tester.internal.assertion.getter.GetterAssertionError;
import pl.pojo.tester.internal.utils.FieldUtils;

public class GetterAssertions {
    private final Object objectUnderAssert;
    private final Class<?> classUnderTest;

    public GetterAssertions(Object objectUnderAssert) {
        this.objectUnderAssert = objectUnderAssert;
        this.classUnderTest = objectUnderAssert.getClass();
    }

    public void willGetValueFromField(Method getter, Field field) throws IllegalAccessException, InvocationTargetException {
        getter.setAccessible(true);
        Object valueFromGetter = getter.invoke(this.objectUnderAssert, new Object[0]);
        Object value = FieldUtils.getValue(this.objectUnderAssert, field);
        boolean result = Objects.equals(value, valueFromGetter);
        this.checkResult(result, new GetterAssertionError(this.classUnderTest, field, valueFromGetter, value));
    }

    private void checkResult(boolean pass, GetterAssertionError errorToThrow) {
        if (!pass) {
            throw errorToThrow;
        }
    }
}

