/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.constructor;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Collectors;
import pl.pojo.tester.internal.assertion.AssertionError;

public class ConstructorAssertionError
extends AssertionError {
    private static final String INSTANTIATE_EXCEPTION = "Constructor:\n%s\nof class:\n%s\ncould not create instance with parameters:\n%s\nRoot cause is:\n%s";
    private final Constructor<?> constructorUnderAssert;
    private final Object[] constructorParameters;
    private final ReflectiveOperationException cause;

    ConstructorAssertionError(Class<?> classUnderTest, Constructor<?> constructorUnderAssert, Object[] constructorParameters, ReflectiveOperationException cause) {
        super(classUnderTest);
        this.constructorUnderAssert = constructorUnderAssert;
        this.cause = cause;
        this.constructorParameters = constructorParameters == null ? null : Arrays.copyOf(constructorParameters, constructorParameters.length);
    }

    @Override
    protected String getErrorPrefix() {
        return String.format("Class %s has bad 'constructor' method implementation.", this.testedCass.getCanonicalName());
    }

    @Override
    protected String getDetailedMessage() {
        return String.format(INSTANTIATE_EXCEPTION, this.constructorUnderAssert, this.testedCass, this.createArrayContentString(this.constructorParameters), this.cause.getMessage());
    }

    private String createArrayContentString(Object ... array) {
        if (array == null) {
            return "<no parameters>";
        }
        return Arrays.stream(array).map(String::valueOf).collect(Collectors.joining(", ", "[ ", " ]"));
    }
}

