/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import pl.pojo.tester.internal.utils.FieldUtils;

public final class FieldPredicate {
    private FieldPredicate() {
    }

    public static Predicate<String> includeAllFields(Class<?> clazz) {
        List<String> allFieldNames = FieldUtils.getAllFieldNames(clazz);
        Predicate<String> predicate = FieldPredicate.getAlwaysFalsePredicate();
        for (String filedName : allFieldNames) {
            predicate = predicate.or(FieldPredicate.getEqualPredicate(filedName));
        }
        return predicate;
    }

    public static Predicate<String> include(List<String> includedFields) {
        Predicate<String> predicate = FieldPredicate.getAlwaysFalsePredicate();
        for (String filedName : includedFields) {
            predicate = predicate.or(FieldPredicate.getEqualPredicate(filedName));
        }
        return predicate;
    }

    public static Predicate<String> include(String ... includedFields) {
        return FieldPredicate.include(Arrays.asList(includedFields));
    }

    public static Predicate<String> exclude(List<String> excludedFields) {
        Predicate<String> predicate = FieldPredicate.getAlwaysTruePredicate();
        for (String filedName : excludedFields) {
            predicate = predicate.and(FieldPredicate.getNonEqualPredicate(filedName));
        }
        return predicate;
    }

    public static Predicate<String> exclude(String ... excludedFields) {
        return FieldPredicate.exclude(Arrays.asList(excludedFields));
    }

    private static Predicate<String> getAlwaysFalsePredicate() {
        return fieldName -> false;
    }

    private static Predicate<String> getAlwaysTruePredicate() {
        return fieldName -> true;
    }

    private static Predicate<String> getNonEqualPredicate(String filedName) {
        return FieldPredicate.getEqualPredicate(filedName).negate();
    }

    private static Predicate<String> getEqualPredicate(String filedName) {
        return otherFieldName -> otherFieldName.equals(filedName);
    }
}

