/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import pl.pojo.tester.api.PackageFilter;
import pl.pojo.tester.api.PackageFilterException;
import pl.pojo.tester.internal.instantiator.ClassLoader;
import pl.pojo.tester.internal.preconditions.ParameterPreconditions;

public final class DefaultPackageFilter
implements PackageFilter {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String FILE_SEPARATOR = "/";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final File packageFile;
    private final String packageName;

    private DefaultPackageFilter(String packageName) {
        ParameterPreconditions.checkNotBlank("packageName", packageName);
        this.packageName = packageName;
        this.packageFile = this.getFile(packageName);
    }

    public static DefaultPackageFilter forPackage(String packageName) {
        return new DefaultPackageFilter(packageName);
    }

    public static DefaultPackageFilter forClass(Class<?> clazz) {
        return new DefaultPackageFilter(clazz.getPackage().getName());
    }

    @Override
    public Class<?>[] getClasses() {
        try {
            Predicate<File> onlyFiles = file -> !file.isDirectory();
            return (Class[])Files.walk(this.packageFile.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(onlyFiles).map(this::replaceSlashesWithDots).map(this::extractPackageName).map(this::removeClassSuffix).map(ClassLoader::loadClass).toArray(Class[]::new);
        }
        catch (IOException e) {
            throw new PackageFilterException(this.packageFile.toString(), e);
        }
    }

    private String replaceSlashesWithDots(File file) {
        return file.toString().replaceAll(Matcher.quoteReplacement(File.separator), PACKAGE_SEPARATOR);
    }

    private String extractPackageName(String dottedString) {
        return dottedString.substring(dottedString.indexOf(this.packageName));
    }

    private String removeClassSuffix(String classFile) {
        int endIndex = classFile.length() - CLASS_FILE_SUFFIX.length();
        return classFile.substring(0, endIndex);
    }

    private File getFile(String packageName) {
        String packagePath = packageName.replaceAll("\\.", FILE_SEPARATOR);
        URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(packagePath);
        if (fileUrl == null) {
            throw new PackageFilterException(packagePath, null);
        }
        return new File(fileUrl.getFile());
    }
}

