/*
 * Decompiled with CFR 0.152.
 */
package pl.owsica.andrzej.frameprogressbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import pl.owsica.andrzej.frameprogressbar.R;
import pl.owsica.andrzej.frameprogressbar.utils.CalculationUtil;
import pl.owsica.andrzej.frameprogressbar.utils.Direction;

public class FrameProgressBar
extends ViewGroup {
    private final Paint mFramePaint = new Paint();
    private final Paint mProgressPaint = new Paint();
    private final Path path = new Path();
    private float mProgress;
    private int mFrameThickness = 10;
    private int mLastFrameThickness;
    private int mStartPlace = 3;
    private boolean mClockwise;
    private boolean mIndeterminate;
    private int mIndeterminePlace;
    private float mIndetermineLocation = 0.0f;
    private float mIndetermineLength;
    private float mIndetermineSpeed = 20.0f;
    private int frameBackgroundColor;
    private int frameProgressColor;
    final Rect mContainerRect = new Rect();
    final Rect mRealChildRect = new Rect();
    final Rect mFramedChildRect = new Rect();

    public FrameProgressBar(Context context) {
        super(context);
        this.mIndeterminePlace = this.mStartPlace;
        this.mIndetermineLength = CalculationUtil.convertDpToPx(40.0f, this.getContext());
        this.initPaints();
        this.setWillNotDraw(false);
    }

    public FrameProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mIndeterminePlace = this.mStartPlace;
        this.mIndetermineLength = CalculationUtil.convertDpToPx(40.0f, this.getContext());
        this.initPaints();
        this.setWillNotDraw(false);
        this.initAttrs(attrs);
    }

    public FrameProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mIndeterminePlace = this.mStartPlace;
        this.mIndetermineLength = CalculationUtil.convertDpToPx(40.0f, this.getContext());
        this.initPaints();
        this.setWillNotDraw(false);
        this.initAttrs(attrs);
    }

    @TargetApi(value=21)
    public FrameProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mIndeterminePlace = this.mStartPlace;
        this.mIndetermineLength = CalculationUtil.convertDpToPx(40.0f, this.getContext());
        this.initPaints();
        this.setWillNotDraw(false);
        this.initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FrameProgressBar);
        this.mClockwise = a.getBoolean(R.styleable.FrameProgressBar_clockwise, true);
        this.mStartPlace = a.getInt(R.styleable.FrameProgressBar_start_place, 3);
        this.mFrameThickness = this.mLastFrameThickness = CalculationUtil.convertDpToPx(a.getInt(R.styleable.FrameProgressBar_frame_thickness, 10), this.getContext());
        this.mProgressPaint.setStrokeWidth((float)this.mFrameThickness);
        this.mProgress = a.getFloat(R.styleable.FrameProgressBar_progress, 0.0f);
        this.frameBackgroundColor = a.getColor(R.styleable.FrameProgressBar_background_color, ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        this.mFramePaint.setColor(this.frameBackgroundColor);
        this.frameProgressColor = a.getColor(R.styleable.FrameProgressBar_progress_color, ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.mProgressPaint.setColor(this.frameProgressColor);
        this.mIndeterminate = a.getBoolean(R.styleable.FrameProgressBar_indeterminate, false);
        this.mIndetermineSpeed = a.getFloat(R.styleable.FrameProgressBar_indeterminate_speed, 10.0f);
        this.mIndetermineLength = a.getDimension(R.styleable.FrameProgressBar_indeterminate_length, (float)CalculationUtil.convertDpToPx(40.0f, this.getContext()));
        a.recycle();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.progress = this.mProgress;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(this.mProgress);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxHeight = 0;
        int maxWidth = 0;
        View child = this.getChildAt(0);
        if (child.getVisibility() != 8) {
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            maxHeight += lp.bottomMargin + lp.topMargin;
            maxWidth += lp.leftMargin + lp.rightMargin;
            maxHeight += child.getMeasuredHeight() + 2 * this.mFrameThickness;
            maxWidth += child.getMeasuredWidth() + 2 * this.mFrameThickness;
        }
        this.getLayoutParams().height = maxHeight;
        this.getLayoutParams().width = maxWidth;
        this.setMeasuredDimension(maxWidth, maxHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int leftPos = this.getPaddingLeft();
        int rightPos = right - left - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = bottom - top - this.getPaddingBottom();
        View child = this.getChildAt(0);
        if (child.getVisibility() != 8) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            this.mContainerRect.left = leftPos - this.mFrameThickness;
            this.mContainerRect.right = rightPos + this.mFrameThickness;
            this.mContainerRect.top = parentTop;
            this.mContainerRect.bottom = parentBottom;
            this.mFramedChildRect.left = leftPos + this.mFrameThickness;
            this.mFramedChildRect.top = parentTop + this.mFrameThickness;
            this.mFramedChildRect.right = rightPos - this.mFrameThickness;
            this.mFramedChildRect.bottom = parentBottom - this.mFrameThickness;
            this.mRealChildRect.left = this.mFramedChildRect.left + lp.leftMargin;
            this.mRealChildRect.top = this.mFramedChildRect.top - lp.topMargin;
            this.mRealChildRect.right = this.mFramedChildRect.right - lp.rightMargin;
            this.mRealChildRect.bottom = this.mFramedChildRect.bottom + lp.bottomMargin;
            Gravity.apply((int)lp.gravity, (int)width, (int)height, (Rect)this.mContainerRect, (Rect)this.mRealChildRect);
            child.layout(this.mRealChildRect.left, this.mRealChildRect.top, this.mRealChildRect.right, this.mRealChildRect.bottom);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mFrameThickness > 0) {
            canvas.drawRect((float)this.mContainerRect.left, (float)this.mContainerRect.top, (float)this.mFramedChildRect.left, (float)this.mContainerRect.bottom, this.mFramePaint);
            canvas.drawRect((float)this.mFramedChildRect.right, (float)this.mContainerRect.top, (float)this.mContainerRect.right, (float)this.mContainerRect.bottom, this.mFramePaint);
            canvas.drawRect((float)this.mFramedChildRect.left, (float)this.mFramedChildRect.bottom, (float)this.mFramedChildRect.right, (float)this.mContainerRect.bottom, this.mFramePaint);
            canvas.drawRect((float)this.mFramedChildRect.left, (float)this.mContainerRect.top, (float)this.mFramedChildRect.right, (float)this.mFramedChildRect.top, this.mFramePaint);
            this.path.reset();
            int circuit = 2 * canvas.getWidth() + 2 * canvas.getHeight();
            if (this.isIndeterminate()) {
                float indeterminateSpeed = this.mIndetermineSpeed / 10.0f;
                switch (this.mIndeterminePlace) {
                    case 3: {
                        if (this.mClockwise) {
                            this.path.moveTo((float)(this.mContainerRect.left + this.mFrameThickness) + this.mIndetermineLocation, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                            this.path.lineTo((float)(this.mContainerRect.left + this.mFrameThickness) + this.mIndetermineLocation + this.mIndetermineLength, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                            this.mIndetermineLocation += indeterminateSpeed;
                            if (!((float)(this.mContainerRect.left + this.mFrameThickness * 2) + this.mIndetermineLocation + this.mIndetermineLength > (float)this.mContainerRect.right)) break;
                            float cornerOffset = (float)(this.mContainerRect.left + this.mFrameThickness * 2) + this.mIndetermineLocation + this.mIndetermineLength - (float)this.mContainerRect.right;
                            this.path.moveTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                            this.path.lineTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top + this.mFrameThickness / 2) + cornerOffset);
                            if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                            this.mIndeterminePlace = 2;
                            this.mIndetermineLocation = 0.0f;
                            break;
                        }
                        this.path.moveTo((float)(this.mContainerRect.right - this.mFrameThickness) + this.mIndetermineLocation, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                        this.path.lineTo((float)(this.mContainerRect.right - this.mFrameThickness) + this.mIndetermineLocation - this.mIndetermineLength, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                        this.mIndetermineLocation -= indeterminateSpeed;
                        if (!((float)(this.mContainerRect.right - this.mFrameThickness * 2) + this.mIndetermineLocation - this.mIndetermineLength < (float)this.mContainerRect.left)) break;
                        float cornerOffset = (float)this.mContainerRect.left - ((float)(this.mContainerRect.right - this.mFrameThickness * 2) + this.mIndetermineLocation - this.mIndetermineLength);
                        this.path.moveTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                        this.path.lineTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top + this.mFrameThickness / 2) + cornerOffset);
                        if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                        this.mIndeterminePlace = 1;
                        this.mIndetermineLocation = 0.0f;
                        break;
                    }
                    case 4: {
                        if (this.mClockwise) {
                            this.path.moveTo((float)(this.mContainerRect.right - this.mFrameThickness) + this.mIndetermineLocation, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                            this.path.lineTo((float)(this.mContainerRect.right - this.mFrameThickness) + this.mIndetermineLocation - this.mIndetermineLength, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                            this.mIndetermineLocation -= indeterminateSpeed;
                            if (!((float)(this.mContainerRect.right - this.mFrameThickness * 2) + this.mIndetermineLocation - this.mIndetermineLength < (float)this.mContainerRect.left)) break;
                            float cornerOffset = (float)this.mContainerRect.left - ((float)(this.mContainerRect.right - this.mFrameThickness * 2) + this.mIndetermineLocation - this.mIndetermineLength);
                            this.path.moveTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                            this.path.lineTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2) - cornerOffset);
                            if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                            this.mIndeterminePlace = 1;
                            this.mIndetermineLocation = 0.0f;
                            break;
                        }
                        this.path.moveTo((float)(this.mContainerRect.left + this.mFrameThickness) + this.mIndetermineLocation, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                        this.path.lineTo((float)(this.mContainerRect.left + this.mFrameThickness) + this.mIndetermineLocation + this.mIndetermineLength, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                        this.mIndetermineLocation += indeterminateSpeed;
                        if (!((float)(this.mContainerRect.left + this.mFrameThickness * 2) + this.mIndetermineLocation + this.mIndetermineLength > (float)this.mContainerRect.right)) break;
                        float cornerOffset = (float)(this.mContainerRect.left + this.mFrameThickness * 2) + this.mIndetermineLocation + this.mIndetermineLength - (float)this.mContainerRect.right;
                        this.path.moveTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                        this.path.lineTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2) - cornerOffset);
                        if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                        this.mIndeterminePlace = 2;
                        this.mIndetermineLocation = 0.0f;
                        break;
                    }
                    case 1: {
                        if (this.mClockwise) {
                            this.path.moveTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation);
                            this.path.lineTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation - this.mIndetermineLength);
                            this.mIndetermineLocation += indeterminateSpeed;
                            if (!((float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation - this.mIndetermineLength < (float)this.mContainerRect.top)) break;
                            float cornerOffset = (float)this.mContainerRect.top - ((float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation - this.mIndetermineLength);
                            this.path.moveTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                            this.path.lineTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f + cornerOffset, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                            if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                            this.mIndeterminePlace = 3;
                            this.mIndetermineLocation = 0.0f;
                            break;
                        }
                        this.path.moveTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation);
                        this.path.lineTo((float)this.mContainerRect.left + (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation + this.mIndetermineLength);
                        this.mIndetermineLocation -= indeterminateSpeed;
                        if (!((float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation + this.mIndetermineLength > (float)this.mContainerRect.bottom)) break;
                        float cornerOffset = (float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation + this.mIndetermineLength - (float)this.mContainerRect.bottom;
                        this.path.moveTo((float)(this.mContainerRect.left + this.mFrameThickness * 2), (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                        this.path.lineTo((float)(this.mContainerRect.left + this.mFrameThickness * 2) + cornerOffset, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                        if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                        this.mIndeterminePlace = 4;
                        this.mIndetermineLocation = 0.0f;
                        break;
                    }
                    case 2: {
                        if (this.mClockwise) {
                            this.path.moveTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation);
                            this.path.lineTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation + this.mIndetermineLength);
                            this.mIndetermineLocation -= indeterminateSpeed;
                            if (!((float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation + this.mIndetermineLength > (float)this.mContainerRect.bottom)) break;
                            float cornerOffset = (float)(this.mContainerRect.top - this.mFrameThickness / 2) - this.mIndetermineLocation + this.mIndetermineLength - (float)this.mContainerRect.bottom;
                            this.path.moveTo((float)(this.mContainerRect.right - this.mFrameThickness * 2), (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                            this.path.lineTo((float)(this.mContainerRect.right - this.mFrameThickness * 2) - cornerOffset, (float)(this.mContainerRect.bottom - this.mFrameThickness / 2));
                            if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                            this.mIndeterminePlace = 4;
                            this.mIndetermineLocation = 0.0f;
                            break;
                        }
                        this.path.moveTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation);
                        this.path.lineTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation - this.mIndetermineLength);
                        this.mIndetermineLocation += indeterminateSpeed;
                        if (!((float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation - this.mIndetermineLength < (float)this.mContainerRect.top)) break;
                        float cornerOffset = (float)this.mContainerRect.top - ((float)(this.mContainerRect.bottom + this.mFrameThickness / 2) - this.mIndetermineLocation - this.mIndetermineLength);
                        this.path.moveTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                        this.path.lineTo((float)this.mContainerRect.right - (float)this.mFrameThickness * 1.5f - cornerOffset, (float)(this.mContainerRect.top + this.mFrameThickness / 2));
                        if (!(cornerOffset > this.mIndetermineLength - (float)this.mFrameThickness)) break;
                        this.mIndeterminePlace = 3;
                        this.mIndetermineLocation = 0.0f;
                    }
                }
                canvas.drawPath(this.path, this.mProgressPaint);
                this.invalidate();
            } else {
                float length = (float)circuit * this.mProgress / 100.0f;
                boolean drawn = false;
                boolean initialPosition = true;
                int currentPlace = this.mStartPlace;
                Direction.DrawStop drawEnd = Direction.getDrawEnd(length, canvas.getWidth(), canvas.getHeight(), this.mStartPlace, this.mClockwise);
                while (!drawn) {
                    Direction.Vector2 endPos;
                    if (initialPosition) {
                        Direction.Vector2 initialPos = Direction.initialPosition(currentPlace, this.mFrameThickness, this.mContainerRect, canvas);
                        this.path.moveTo(initialPos.x, initialPos.y);
                        if (drawEnd.place == currentPlace && Direction.isEndOnFirstLedge(drawEnd, canvas, this.mClockwise, this.mProgress) && this.mProgress != 100.0f) {
                            endPos = Direction.finishPosition(drawEnd, this.mFrameThickness, this.mFramedChildRect);
                            this.path.lineTo(endPos.x, endPos.y);
                            drawn = true;
                        } else {
                            endPos = Direction.calculateEnd(currentPlace, this.mFrameThickness, this.mClockwise, this.mContainerRect, canvas);
                            this.path.lineTo(endPos.x, endPos.y);
                            currentPlace = Direction.nextDirection(currentPlace, this.mClockwise);
                        }
                        initialPosition = false;
                        continue;
                    }
                    Direction.Vector2 startPos = Direction.startPosition(currentPlace, this.mFrameThickness, this.mClockwise, this.mContainerRect, canvas);
                    this.path.moveTo(startPos.x, startPos.y);
                    if (drawEnd.place == currentPlace) {
                        endPos = Direction.finishPosition(drawEnd, this.mFrameThickness, this.mFramedChildRect);
                        this.path.lineTo(endPos.x, endPos.y);
                        drawn = true;
                        continue;
                    }
                    endPos = Direction.calculateEnd(currentPlace, this.mFrameThickness, this.mClockwise, this.mContainerRect, canvas);
                    this.path.lineTo(endPos.x, endPos.y);
                    currentPlace = Direction.nextDirection(currentPlace, this.mClockwise);
                }
                canvas.drawPath(this.path, this.mProgressPaint);
            }
        }
    }

    private void initPaints() {
        this.mProgressPaint.setColor(this.frameProgressColor);
        this.mProgressPaint.setStrokeWidth((float)this.mFrameThickness);
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mFramePaint.setColor(this.frameBackgroundColor);
        this.mFramePaint.setAntiAlias(true);
    }

    public void show() {
        if (!this.isVisible()) {
            this.mFrameThickness = this.mLastFrameThickness;
            this.mProgressPaint.setStrokeWidth((float)this.mLastFrameThickness);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void hide() {
        if (this.isVisible()) {
            this.mLastFrameThickness = this.mFrameThickness;
            this.mFrameThickness = 0;
            this.mProgressPaint.setStrokeWidth(0.0f);
            this.requestLayout();
            this.invalidate();
        }
    }

    public boolean isVisible() {
        return this.mFrameThickness > 0;
    }

    public void setProgress(float mProgress) {
        boolean changed = false;
        if (mProgress != this.mProgress) {
            changed = true;
        }
        this.mProgress = mProgress < 0.0f ? 0.0f : (mProgress > 100.0f ? 100.0f : mProgress);
        if (changed) {
            this.invalidate();
        }
    }

    public void setFrameThickness(int mFrameThickness) {
        if (mFrameThickness < 0) {
            this.mLastFrameThickness = 0;
            this.mFrameThickness = 0;
            this.mProgressPaint.setStrokeWidth(0.0f);
            this.requestLayout();
            this.invalidate();
        } else if (mFrameThickness != this.mFrameThickness) {
            this.mFrameThickness = this.mLastFrameThickness = CalculationUtil.convertDpToPx(mFrameThickness, this.getContext());
            this.mProgressPaint.setStrokeWidth((float)this.mFrameThickness);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setFrameBackgroundColor(int frameBackgroundColor) {
        this.frameBackgroundColor = frameBackgroundColor;
        this.mFramePaint.setColor(frameBackgroundColor);
        this.invalidate();
    }

    public void setFrameProgressColor(int frameProgressColor) {
        this.frameProgressColor = frameProgressColor;
        this.mProgressPaint.setColor(frameProgressColor);
        this.invalidate();
    }

    public void setStartPlace(int place) {
        if (Direction.isDirection(place)) {
            this.mStartPlace = place;
            this.invalidate();
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        this.mIndeterminate = indeterminate;
        this.invalidate();
    }

    public boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    public void setIndetermineSpeed(float mIndetermineSpeed) {
        this.mIndetermineSpeed = mIndetermineSpeed;
    }

    public float getIndetermineSpeed() {
        return this.mIndetermineSpeed;
    }

    public void setClockwise(boolean clockwise) {
        this.mClockwise = clockwise;
        this.mIndetermineLocation = 0.0f;
        this.invalidate();
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = 17;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FrameProgressBar);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        float progress;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.progress = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.progress);
        }
    }
}

