/*
 * Decompiled with CFR 0.152.
 */
package pl.owsica.andrzej.frameprogressbar.utils;

import android.graphics.Canvas;
import android.graphics.Rect;
import java.util.Random;

public class Direction {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    private static Random rand = new Random();

    public static int random() {
        return rand.nextInt(4) + 1;
    }

    public static boolean isDirection(int num) {
        return num >= 1 && num <= 4;
    }

    public static String toString(int dir) {
        switch (dir) {
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "RIGHT";
            }
            case 3: {
                return "TOP";
            }
            case 4: {
                return "BOTTOM";
            }
        }
        return null;
    }

    public static DrawStop getDrawEnd(float length, float width, float height, int startPlace, boolean clockwise) {
        DrawStop drawStop = new DrawStop();
        float halfOfCanvasWidth = width / 2.0f;
        float halfOfCanvasHeight = height / 2.0f;
        int currentPlace = startPlace;
        float lengthLeft = length;
        boolean placeFound = false;
        boolean firstPlace = true;
        while (!placeFound) {
            if (currentPlace == 3 || currentPlace == 4) {
                if (firstPlace) {
                    if (lengthLeft < halfOfCanvasWidth) {
                        drawStop.place = currentPlace;
                        drawStop.location = clockwise ? (currentPlace == 3 ? halfOfCanvasWidth + lengthLeft : halfOfCanvasWidth - lengthLeft) : (currentPlace == 3 ? halfOfCanvasWidth - lengthLeft : halfOfCanvasWidth + lengthLeft);
                        placeFound = true;
                    } else {
                        currentPlace = Direction.nextDirection(currentPlace, clockwise);
                        lengthLeft -= halfOfCanvasWidth;
                    }
                    firstPlace = false;
                    continue;
                }
                if (lengthLeft < width) {
                    drawStop.place = currentPlace;
                    drawStop.location = clockwise ? (currentPlace == 3 ? lengthLeft : width - lengthLeft) : (currentPlace == 3 ? width - lengthLeft : lengthLeft);
                    placeFound = true;
                    continue;
                }
                currentPlace = Direction.nextDirection(currentPlace, clockwise);
                lengthLeft -= width;
                continue;
            }
            if (firstPlace) {
                if (lengthLeft < halfOfCanvasHeight) {
                    drawStop.place = currentPlace;
                    drawStop.location = clockwise ? (currentPlace == 2 ? halfOfCanvasHeight + lengthLeft : halfOfCanvasHeight - lengthLeft) : (currentPlace == 2 ? halfOfCanvasHeight - lengthLeft : halfOfCanvasHeight + lengthLeft);
                    placeFound = true;
                } else {
                    currentPlace = Direction.nextDirection(currentPlace, clockwise);
                    lengthLeft -= halfOfCanvasHeight;
                }
                firstPlace = false;
                continue;
            }
            if (lengthLeft < height) {
                drawStop.place = currentPlace;
                drawStop.location = clockwise ? (currentPlace == 2 ? lengthLeft : height - lengthLeft) : (currentPlace == 2 ? height - lengthLeft : lengthLeft);
                placeFound = true;
                continue;
            }
            currentPlace = Direction.nextDirection(currentPlace, clockwise);
            lengthLeft -= height;
        }
        return drawStop;
    }

    public static int nextDirection(int dir, boolean clockwise) {
        switch (dir) {
            case 3: {
                if (clockwise) {
                    return 2;
                }
                return 1;
            }
            case 2: {
                if (clockwise) {
                    return 4;
                }
                return 3;
            }
            case 4: {
                if (clockwise) {
                    return 1;
                }
                return 2;
            }
            case 1: {
                if (clockwise) {
                    return 3;
                }
                return 4;
            }
        }
        return 0;
    }

    public static Vector2 initialPosition(int direction, float frameThickness, Rect container, Canvas canvas) {
        switch (direction) {
            case 1: {
                return new Vector2((float)container.left + frameThickness * 1.5f, canvas.getHeight() / 2);
            }
            case 2: {
                return new Vector2((float)container.right - frameThickness * 1.5f, canvas.getHeight() / 2);
            }
            case 3: {
                return new Vector2(canvas.getWidth() / 2, (float)container.top + frameThickness / 2.0f);
            }
            case 4: {
                return new Vector2(canvas.getWidth() / 2, (float)container.bottom - frameThickness / 2.0f);
            }
        }
        return new Vector2();
    }

    public static Vector2 startPosition(int direction, float frameThickness, boolean clockwise, Rect container, Canvas canvas) {
        switch (direction) {
            case 2: {
                if (clockwise) {
                    return new Vector2((float)container.right - frameThickness * 1.5f, frameThickness);
                }
                return new Vector2((float)container.right - frameThickness * 1.5f, (float)canvas.getHeight() - frameThickness);
            }
            case 1: {
                if (clockwise) {
                    return new Vector2((float)container.left + frameThickness * 1.5f, (float)canvas.getHeight() - frameThickness);
                }
                return new Vector2((float)container.left + frameThickness * 1.5f, frameThickness);
            }
            case 3: {
                if (clockwise) {
                    return new Vector2(frameThickness, (float)container.top + frameThickness / 2.0f);
                }
                return new Vector2((float)canvas.getWidth() - frameThickness, (float)container.top + frameThickness / 2.0f);
            }
            case 4: {
                if (clockwise) {
                    return new Vector2((float)canvas.getWidth() - frameThickness, (float)container.bottom - frameThickness / 2.0f);
                }
                return new Vector2(frameThickness, (float)container.bottom - frameThickness / 2.0f);
            }
        }
        return new Vector2();
    }

    public static Vector2 finishPosition(DrawStop drawStop, float frameThickness, Rect framedChild) {
        switch (drawStop.place) {
            case 2: {
                return new Vector2((float)framedChild.right + frameThickness / 2.0f, drawStop.location);
            }
            case 1: {
                return new Vector2((float)framedChild.left - frameThickness / 2.0f, drawStop.location);
            }
            case 3: {
                return new Vector2(drawStop.location, (float)framedChild.top - frameThickness / 2.0f);
            }
            case 4: {
                return new Vector2(drawStop.location, (float)framedChild.bottom + frameThickness / 2.0f);
            }
        }
        return new Vector2();
    }

    public static Vector2 calculateEnd(int currentPlace, float frameThickness, boolean clockwise, Rect container, Canvas canvas) {
        switch (currentPlace) {
            case 2: {
                if (clockwise) {
                    return new Vector2((float)container.right - frameThickness * 1.5f, canvas.getHeight());
                }
                return new Vector2((float)container.right - frameThickness * 1.5f, 0.0f);
            }
            case 1: {
                if (clockwise) {
                    return new Vector2((float)container.left + frameThickness * 1.5f, 0.0f);
                }
                return new Vector2((float)container.left + frameThickness * 1.5f, canvas.getHeight());
            }
            case 3: {
                if (clockwise) {
                    return new Vector2(canvas.getWidth(), (float)container.top + frameThickness / 2.0f);
                }
                return new Vector2(0.0f, (float)container.top + frameThickness / 2.0f);
            }
            case 4: {
                if (clockwise) {
                    return new Vector2(0.0f, (float)container.bottom - frameThickness / 2.0f);
                }
                return new Vector2(canvas.getWidth(), (float)container.bottom - frameThickness / 2.0f);
            }
        }
        return new Vector2();
    }

    public static boolean isEndOnFirstLedge(DrawStop drawEnd, Canvas canvas, boolean clockwise, float progress) {
        switch (drawEnd.place) {
            case 2: {
                return clockwise && drawEnd.location >= (float)(canvas.getHeight() / 2) || !clockwise && drawEnd.location <= (float)(canvas.getHeight() / 2) || progress == 0.0f;
            }
            case 1: {
                return clockwise && drawEnd.location <= (float)(canvas.getHeight() / 2) || !clockwise && drawEnd.location >= (float)(canvas.getHeight() / 2) || progress == 0.0f;
            }
            case 3: {
                return clockwise && drawEnd.location >= (float)(canvas.getWidth() / 2) || !clockwise && drawEnd.location <= (float)(canvas.getWidth() / 2) || progress == 0.0f;
            }
            case 4: {
                return clockwise && drawEnd.location <= (float)(canvas.getWidth() / 2) || !clockwise && drawEnd.location >= (float)(canvas.getWidth() / 2) || progress == 0.0f;
            }
        }
        return false;
    }

    public static boolean isVertical(int direction) {
        switch (direction) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isHorizontal(int direction) {
        switch (direction) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static class Vector2 {
        public float x;
        public float y = 0.0f;

        public Vector2() {
        }

        public Vector2(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class DrawStop {
        public int place;
        public float location;

        public String toString() {
            return Direction.toString(this.place) + "|" + this.location;
        }
    }
}

