/*
 * Decompiled with CFR 0.152.
 */
package pl.openrnd.multilevellistview;

import java.util.List;
import pl.openrnd.multilevellistview.NodeItemInfo;

class Node {
    private Object mObject;
    private int mLevel;
    private Node mParent;
    private List<Node> mSubNodes;
    private int mIdxInLevel;
    private int mLevelSize;
    private boolean mIsExpandable;
    private NodeItemInfo mNodeItemInfo;

    Node(Object object, Node parent) {
        this.mObject = object;
        this.mParent = parent;
        this.mLevel = parent.mLevel + 1;
    }

    Node() {
        this.mLevel = -1;
    }

    Object getObject() {
        return this.mObject;
    }

    int getLevel() {
        return this.mLevel;
    }

    Node getParent() {
        return this.mParent;
    }

    void clearSubNodes() {
        this.mSubNodes = null;
    }

    void setSubNodes(List<Node> nodes) {
        this.mSubNodes = nodes;
        int NODES = nodes.size();
        int i = 0;
        while (i < NODES) {
            Node node = nodes.get(i);
            node.mLevelSize = NODES;
            node.mIdxInLevel = i++;
        }
    }

    boolean isExpanded() {
        return this.mSubNodes != null;
    }

    int getIdxInLevel() {
        return this.mIdxInLevel;
    }

    int getLevelSize() {
        return this.mLevelSize;
    }

    List<Node> getSubNodes() {
        return this.mSubNodes;
    }

    NodeItemInfo getItemInfo() {
        if (this.mNodeItemInfo == null) {
            this.mNodeItemInfo = new NodeItemInfo(this);
        }
        return this.mNodeItemInfo;
    }

    void setExpandable(boolean isExpandable) {
        this.mIsExpandable = isExpandable;
    }

    boolean isExpandable() {
        return this.mIsExpandable;
    }
}

