/*
 * Decompiled with CFR 0.152.
 */
package pl.openrnd.multilevellistview;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;
import pl.openrnd.multilevellistview.ItemInfo;
import pl.openrnd.multilevellistview.MultiLevelListView;
import pl.openrnd.multilevellistview.NestType;
import pl.openrnd.multilevellistview.Node;

public abstract class MultiLevelListAdapter {
    private MultiLevelListView mView;
    private Node mRoot = new Node();
    private List<Node> mFlatItems = new ArrayList<Node>();
    private List<Object> mSourceData = new ArrayList<Object>();
    private ProxyAdapter mProxyAdapter = new ProxyAdapter();

    protected abstract boolean isExpandable(Object var1);

    protected abstract List<?> getSubObjects(Object var1);

    protected abstract View getViewForObject(Object var1, View var2, ItemInfo var3);

    public void setDataItems(List<?> dataItems) {
        this.checkState();
        this.mSourceData = new ArrayList<Object>();
        this.mSourceData.addAll(dataItems);
        this.mRoot.setSubNodes(this.createNodeListFromDataItems(this.mSourceData, this.mRoot));
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.checkState();
        this.mFlatItems = this.createItemsForCurrentStat();
        this.mProxyAdapter.notifyDataSetChanged();
    }

    void reloadData() {
        this.setDataItems(this.mSourceData);
    }

    private void checkState() {
        if (this.mView == null) {
            throw new IllegalStateException("Adapter not connected");
        }
    }

    private List<Node> createNodeListFromDataItems(List<?> dataItems, Node parent) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (dataItems != null) {
            for (Object dataItem : dataItems) {
                boolean isExpandable = this.isExpandable(dataItem);
                Node node = new Node(dataItem, parent);
                node.setExpandable(isExpandable);
                if (this.mView.isAlwaysExpanded() && isExpandable) {
                    node.setSubNodes(this.createNodeListFromDataItems(this.getSubObjects(node.getObject()), node));
                }
                result.add(node);
            }
        }
        return result;
    }

    private List<Node> createItemsForCurrentStat() {
        ArrayList<Node> result = new ArrayList<Node>();
        this.collectItems(result, this.mRoot.getSubNodes());
        return result;
    }

    private void collectItems(List<Node> result, List<Node> nodes) {
        if (nodes != null) {
            for (Node node : nodes) {
                result.add(node);
                this.collectItems(result, node.getSubNodes());
            }
        }
    }

    List<Node> getFlatItems() {
        return this.mFlatItems;
    }

    void unregisterView(MultiLevelListView view) {
        if (this.mView != view) {
            throw new IllegalArgumentException("Adapter not connected");
        }
        if (this.mView == null) {
            return;
        }
        this.mView.getListView().setAdapter(null);
        this.mView = null;
    }

    void registerView(MultiLevelListView view) {
        if (this.mView != null && this.mView != view) {
            throw new IllegalArgumentException("Adapter already connected");
        }
        if (view == null) {
            return;
        }
        this.mView = view;
        this.mView.getListView().setAdapter((ListAdapter)this.mProxyAdapter);
    }

    void extendNode(Node node, NestType nestTyp) {
        node.setSubNodes(this.createNodeListFromDataItems(this.getSubObjects(node.getObject()), node));
        if (nestTyp == NestType.SINGLE) {
            this.clearPathToNode(node);
        }
        this.notifyDataSetChanged();
    }

    void collapseNode(Node node) {
        node.clearSubNodes();
        this.notifyDataSetChanged();
    }

    private void clearPathToNode(Node node) {
        Node parent = node.getParent();
        if (parent != null) {
            List<Node> nodes = parent.getSubNodes();
            if (nodes != null) {
                for (Node sibling : nodes) {
                    if (sibling == node) continue;
                    sibling.clearSubNodes();
                }
            }
            this.clearPathToNode(parent);
        }
    }

    private class ProxyAdapter
    extends BaseAdapter {
        private ProxyAdapter() {
        }

        public int getCount() {
            return MultiLevelListAdapter.this.mFlatItems == null ? 0 : MultiLevelListAdapter.this.mFlatItems.size();
        }

        public Object getItem(int i) {
            return MultiLevelListAdapter.this.mFlatItems.get(i);
        }

        public long getItemId(int i) {
            return i;
        }

        public View getView(int i, View convertView, ViewGroup viewGroup) {
            Node node = (Node)MultiLevelListAdapter.this.mFlatItems.get(i);
            return MultiLevelListAdapter.this.getViewForObject(node.getObject(), convertView, node.getItemInfo());
        }
    }
}

