/*
 * Decompiled with CFR 0.152.
 */
package pl.coreorb.selectiondialogs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import pl.coreorb.selectiondialogs.R;
import pl.coreorb.selectiondialogs.data.SelectableColor;
import pl.coreorb.selectiondialogs.data.SelectableIcon;

public class SelectedItemView
extends LinearLayout {
    private static String TAG = SelectedItemView.class.getSimpleName();
    private TextView hintTV;
    private RelativeLayout buttonRL;
    private TextView nameTV;
    private ImageView iconIV;
    private String currentHint;
    private String currentItemId;
    private String currentItemName;
    @DrawableRes
    private int currentItemIcon;
    @ColorInt
    private int currentItemColor;

    public SelectedItemView(Context context) {
        this(context, null);
    }

    public SelectedItemView(Context context, int id2) {
        this(context, null, id2);
    }

    public SelectedItemView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public SelectedItemView(Context context, AttributeSet attrs, Integer id2) {
        super(context, attrs);
        if (id2 != null) {
            this.setId(id2);
        }
        Log.d((String)TAG, (String)("SelectedItemView() [id: " + this.getId() + "]"));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SelectedItemView, 0, 0);
        String hint = a.getString(R.styleable.SelectedItemView_hint);
        String itemId = a.getString(R.styleable.SelectedItemView_itemId);
        int itemIcon = a.getResourceId(R.styleable.SelectedItemView_itemIcon, -1);
        int itemColor = a.getInt(R.styleable.SelectedItemView_itemColor, -1);
        String itemName = a.getString(R.styleable.SelectedItemView_itemName);
        a.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View rootView = inflater.inflate(R.layout.selectiondialogs_selected_item_view, (ViewGroup)this, true);
        this.hintTV = (TextView)rootView.findViewById(R.id.selectiondialogs_hint_tv);
        this.buttonRL = (RelativeLayout)rootView.findViewById(R.id.selectiondialogs_button_ll);
        this.nameTV = (TextView)rootView.findViewById(R.id.selectiondialogs_name_tv);
        this.iconIV = (ImageView)rootView.findViewById(R.id.selectiondialogs_icon_iv);
        if (hint != null) {
            this.hintTV.setText((CharSequence)hint);
            this.currentHint = hint;
        } else {
            this.currentHint = this.getResources().getString(R.string.selectiondialogs_default_hint);
        }
        this.currentItemId = itemId != null ? itemId : this.getResources().getString(R.string.selectiondialogs_default_item_id);
        if (itemName != null) {
            this.nameTV.setText((CharSequence)itemName);
            this.currentItemName = itemName;
        } else {
            this.currentItemName = this.getResources().getString(R.string.selectiondialogs_default_item_name);
        }
        if (itemIcon != -1) {
            this.iconIV.setImageResource(itemIcon);
            this.currentItemIcon = itemIcon;
        } else {
            this.currentItemIcon = R.drawable.selectiondialogs_default_item_icon;
        }
        if (itemColor != -1) {
            this.iconIV.setColorFilter(itemColor);
            this.currentItemColor = itemColor;
        } else {
            this.currentItemColor = ContextCompat.getColor((Context)context, (int)R.color.selectiondialogs_default_item_color);
        }
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.buttonRL.setOnClickListener(onClickListener);
    }

    public void setHint(String hint) {
        this.currentHint = hint;
        this.hintTV.setText((CharSequence)hint);
    }

    public void setHint(@StringRes int hintResId) {
        this.currentHint = this.getResources().getString(hintResId);
        this.hintTV.setText(hintResId);
    }

    public String getHint() {
        return this.currentHint;
    }

    public void setSelectedName(String name) {
        this.currentItemName = name;
        this.nameTV.setText((CharSequence)name);
    }

    public void setSelectedName(@StringRes int nameResId) {
        this.currentItemName = this.getResources().getString(nameResId);
        this.nameTV.setText(nameResId);
    }

    public String getSelectedName() {
        return this.currentItemName;
    }

    public void setSelectedIcon(SelectableIcon icon) {
        this.currentItemId = icon.getId();
        this.currentItemName = icon.getName();
        this.currentItemIcon = icon.getDrawableResId();
        this.iconIV.setImageResource(icon.getDrawableResId());
        this.nameTV.setText((CharSequence)icon.getName());
    }

    public SelectableIcon getSelectedIcon() {
        return new SelectableIcon(this.currentItemId, this.currentItemName, this.currentItemIcon);
    }

    public void setSelectedColor(SelectableColor color2) {
        this.currentItemId = color2.getId();
        this.currentItemName = color2.getName();
        this.currentItemColor = color2.getColorValue();
        this.iconIV.setColorFilter(color2.getColorValue());
        this.nameTV.setText((CharSequence)color2.getName());
    }

    public SelectableColor getSelectedColor() {
        return new SelectableColor(this.currentItemId, this.currentItemName, this.currentItemColor);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Log.d((String)TAG, (String)("onSaveInstanceState() [id: " + this.getId() + "]"));
        SavedState ss = new SavedState(superState);
        ss.hint = this.currentHint;
        ss.id = this.currentItemId;
        ss.name = this.currentItemName;
        ss.iconDrawableResId = this.currentItemIcon;
        ss.iconColorValue = this.currentItemColor;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        Log.d((String)TAG, (String)("onRestoreInstanceState() [id: " + this.getId() + "]"));
        SavedState ss = (SavedState)state;
        this.currentHint = ss.hint;
        this.currentItemId = ss.id;
        this.currentItemName = ss.name;
        this.currentItemIcon = ss.iconDrawableResId;
        this.currentItemColor = ss.iconColorValue;
        this.hintTV.setText((CharSequence)this.currentHint);
        this.nameTV.setText((CharSequence)this.currentItemName);
        this.iconIV.setImageResource(this.currentItemIcon);
        this.iconIV.setColorFilter(this.currentItemColor);
        super.onRestoreInstanceState(ss.getSuperState());
    }

    static class SavedState
    extends View.BaseSavedState {
        String hint;
        String id;
        String name;
        Integer iconDrawableResId;
        Integer iconColorValue;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.id = in.readString();
            this.name = in.readString();
            this.iconDrawableResId = in.readInt();
            this.iconColorValue = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.id);
            out.writeString(this.name);
            out.writeInt(this.iconDrawableResId.intValue());
            out.writeInt(this.iconColorValue.intValue());
        }
    }
}

