/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.radiodish;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zmq.Ctx;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.net.Address;
import zmq.pipe.Pipe;
import zmq.socket.pubsub.Dist;

public class Radio
extends SocketBase {
    private final Map<String, List<Pipe>> subscriptions;
    private final Dist dist;

    public Radio(Ctx parent, int tid, int sid) {
        super(parent, tid, sid, true);
        this.options.type = 14;
        this.subscriptions = new HashMap<String, List<Pipe>>();
        this.dist = new Dist();
    }

    @Override
    public void xattachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        pipe.setNoDelay();
        this.dist.attach(pipe);
        this.xreadActivated(pipe);
    }

    @Override
    public void xreadActivated(Pipe pipe) {
        Msg msg = pipe.read();
        while (msg != null) {
            List<Pipe> pipes;
            if (msg.isJoin()) {
                if (!this.subscriptions.containsKey(msg.getGroup())) {
                    this.subscriptions.put(msg.getGroup(), new ArrayList());
                }
                pipes = this.subscriptions.get(msg.getGroup());
                pipes.add(pipe);
            } else if (msg.isLeave() && (pipes = this.subscriptions.get(msg.getGroup())) != null) {
                pipes.remove(pipe);
                if (pipes.isEmpty()) {
                    this.subscriptions.remove(msg.getGroup());
                }
            }
            msg = pipe.read();
        }
    }

    @Override
    public void xwriteActivated(Pipe pipe) {
        this.dist.activated(pipe);
    }

    @Override
    public void xpipeTerminated(Pipe pipe) {
        Iterator<Map.Entry<String, List<Pipe>>> i = this.subscriptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, List<Pipe>> entry = i.next();
            entry.getValue().remove(pipe);
            if (!entry.getValue().isEmpty()) continue;
            i.remove();
        }
        this.dist.terminated(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (msg.hasMore()) {
            this.errno.set(22);
            return false;
        }
        this.dist.unmatch();
        List<Pipe> range = this.subscriptions.get(msg.getGroup());
        if (range != null) {
            for (int i = 0; i < range.size(); ++i) {
                this.dist.match(range.get(i));
            }
        }
        this.dist.sendToMatching(msg);
        return true;
    }

    @Override
    protected Msg xrecv() {
        this.errno.set(45);
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean xhasIn() {
        return false;
    }

    @Override
    protected boolean xhasOut() {
        return this.dist.hasOut();
    }

    public static class RadioSession
    extends SessionBase {
        private State state = State.GROUP;
        private Msg pending;

        public RadioSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            super(ioThread, connect, socket, options, addr);
        }

        @Override
        public boolean pushMsg(Msg msg) {
            if (msg.isCommand()) {
                String group;
                byte commandNameSize = msg.get(0);
                if (msg.size() < commandNameSize + 1) {
                    return super.pushMsg(msg);
                }
                byte[] data = msg.data();
                String commandName = new String(data, 1, (int)commandNameSize, StandardCharsets.US_ASCII);
                Msg joinLeaveMsg = new Msg();
                if (commandName.equals("JOIN")) {
                    int groupLength = msg.size() - 5;
                    group = new String(data, 5, groupLength, StandardCharsets.US_ASCII);
                    joinLeaveMsg.initJoin();
                } else if (commandName.equals("LEAVE")) {
                    int groupLength = msg.size() - 6;
                    group = new String(data, 6, groupLength, StandardCharsets.US_ASCII);
                    joinLeaveMsg.initLeave();
                } else {
                    return super.pushMsg(msg);
                }
                joinLeaveMsg.setGroup(group);
                msg = joinLeaveMsg;
                return super.pushMsg(msg);
            }
            return super.pushMsg(msg);
        }

        @Override
        protected Msg pullMsg() {
            Msg msg;
            switch (this.state) {
                case GROUP: {
                    this.pending = super.pullMsg();
                    if (this.pending == null) {
                        return null;
                    }
                    msg = new Msg(this.pending.getGroup().getBytes(StandardCharsets.US_ASCII));
                    msg.setFlags(1);
                    this.state = State.BODY;
                    break;
                }
                case BODY: {
                    msg = this.pending;
                    this.state = State.GROUP;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return msg;
        }

        @Override
        protected void reset() {
            super.reset();
            this.state = State.GROUP;
        }

        static enum State {
            GROUP,
            BODY;

        }
    }
}

