/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.nio.ByteBuffer;

final class ByteBufferUtil {
    ByteBufferUtil() {
    }

    public Index find(ByteBuffer[] bufferQueue, byte[] delimiter) {
        return this.find(bufferQueue, new Index(delimiter));
    }

    public Index find(ByteBuffer[] buffers, Index index) {
        for (int i = this.findFirstBufferToScan(buffers, index); i < buffers.length && !index.hasDelimiterFound; ++i) {
            ByteBuffer buffer = buffers[i];
            if (buffer == null) continue;
            int savedPos = buffer.position();
            int savedLimit = buffer.limit();
            this.findInBuffer(buffer, index);
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
        return index;
    }

    private int findFirstBufferToScan(ByteBuffer[] buffers, Index index) {
        int i = 0;
        if (index.lastScannedBuffer != null) {
            for (int j = 0; j < buffers.length; ++j) {
                if (buffers[j] != index.lastScannedBuffer) continue;
                i = j;
                break;
            }
            if (++i >= buffers.length) {
                return i;
            }
            for (int k = i; k < buffers.length; ++k) {
                if (buffers[k] == null) continue;
                i = k;
                break;
            }
            if (i >= buffers.length) {
                return i;
            }
        }
        return i;
    }

    private void findInBuffer(ByteBuffer buffer, Index index) {
        index.lastScannedBuffer = buffer;
        int dataSize = buffer.remaining();
        byte[] delimiter = index.delimiterBytes;
        int delimiterLength = index.delimiterLength;
        int delimiterPosition = index.delimiterPos;
        byte nextDelimiterByte = delimiter[delimiterPosition];
        boolean delimiterPartsFound = delimiterPosition > 0;
        for (int i = 0; i < dataSize; ++i) {
            byte b = buffer.get();
            if (b == nextDelimiterByte) {
                ++delimiterPosition;
                if (delimiterLength == 1) {
                    index.hasDelimiterFound = true;
                    index.delimiterPos = delimiterPosition;
                    index.readBytes += i + 1;
                    return;
                }
                index.delimiterPos = delimiterPosition;
                if (delimiterPosition == delimiterLength) {
                    index.hasDelimiterFound = true;
                    index.readBytes += i + 1;
                    return;
                }
                nextDelimiterByte = delimiter[delimiterPosition];
                delimiterPartsFound = true;
                continue;
            }
            if (!delimiterPartsFound) continue;
            delimiterPosition = 0;
            index.delimiterPos = 0;
            nextDelimiterByte = delimiter[delimiterPosition];
            delimiterPartsFound = false;
            if (delimiterLength <= 1 || b != nextDelimiterByte) continue;
            nextDelimiterByte = delimiter[++delimiterPosition];
            index.delimiterPos = delimiterPosition;
        }
        index.readBytes += dataSize;
    }

    public ByteBuffer[] extract(ByteBuffer[] inOutBuffers, int length) {
        ByteBuffer[] extracted = null;
        int remainingToExtract = length;
        ByteBuffer buffer = null;
        for (int i = 0; i < inOutBuffers.length; ++i) {
            buffer = inOutBuffers[i];
            if (buffer == null) continue;
            int bufLength = buffer.limit() - buffer.position();
            if (remainingToExtract >= bufLength) {
                extracted = ByteBufferUtil.appendBuffer(extracted, buffer);
                remainingToExtract -= bufLength;
                inOutBuffers[i] = null;
            } else {
                ByteBuffer rightPart;
                int savedLimit = buffer.limit();
                buffer.limit(buffer.position() + remainingToExtract);
                ByteBuffer leftPart = buffer.slice();
                extracted = ByteBufferUtil.appendBuffer(extracted, leftPart);
                buffer.position(buffer.limit());
                buffer.limit(savedLimit);
                inOutBuffers[i] = rightPart = buffer.slice();
                remainingToExtract = 0;
            }
            if (remainingToExtract != 0) continue;
            return extracted;
        }
        return null;
    }

    public static ByteBuffer[] appendBuffer(ByteBuffer[] buffers, ByteBuffer buffer) {
        if (buffers == null) {
            ByteBuffer[] result = new ByteBuffer[]{buffer};
            return result;
        }
        ByteBuffer[] result = new ByteBuffer[buffers.length + 1];
        System.arraycopy(buffers, 0, result, 0, buffers.length);
        result[buffers.length] = buffer;
        return result;
    }

    static final class Index
    implements Cloneable {
        public static final int NULL = -1;
        private boolean hasDelimiterFound = false;
        private byte[] delimiterBytes = null;
        private int delimiterLength = 0;
        private int delimiterPos = 0;
        private int readBytes = 0;
        private ByteBuffer lastScannedBuffer = null;

        Index(byte[] delimiterBytes) {
            this.delimiterBytes = delimiterBytes;
            this.delimiterLength = delimiterBytes.length;
        }

        public boolean hasDelimiterFound() {
            return this.hasDelimiterFound;
        }

        int getContentLength() {
            if (this.hasDelimiterFound) {
                return this.readBytes - this.delimiterLength;
            }
            return -1;
        }

        public int getReadBytes() {
            return this.readBytes;
        }

        public boolean isDelimiterEquals(byte[] other) {
            if (other.length != this.delimiterLength) {
                return false;
            }
            for (int i = 0; i < this.delimiterLength; ++i) {
                if (other[i] == this.delimiterBytes[i]) continue;
                return false;
            }
            return true;
        }

        protected Object clone() throws CloneNotSupportedException {
            Index copy = (Index)super.clone();
            return copy;
        }

        public String toString() {
            return "found=" + this.hasDelimiterFound + " delimiterPos=" + this.delimiterPos + " delimiterLength=" + this.delimiterLength + " readBytes=" + this.readBytes;
        }
    }
}

