/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.xsocket.ILifeCycle;
import org.xsocket.connection.BlockingConnection;
import org.xsocket.connection.IBlockingConnection;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.NonBlockingConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockingConnectionPool
implements IConnectionPool {
    private NonBlockingConnectionPool pool = null;

    public BlockingConnectionPool() {
        this.pool = new NonBlockingConnectionPool();
    }

    public BlockingConnectionPool(SSLContext sslContext) {
        this.pool = new NonBlockingConnectionPool(sslContext);
    }

    @Override
    public boolean isOpen() {
        return this.pool.isOpen();
    }

    public IBlockingConnection getBlockingConnection(String host, int port) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(host, port, false));
    }

    public IBlockingConnection getBlockingConnection(String host, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(host, port, isSSL));
    }

    public IBlockingConnection getBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(host, port, connectTimeoutMillis, false));
    }

    public IBlockingConnection getBlockingConnection(String host, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(host, port, connectTimeoutMillis, isSSL));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(address, port, false));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(address, port, isSSL));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(address, port, connectTimeoutMillis, false));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return new BlockingConnection(this.pool.getNonBlockingConnection(address, port, connectTimeoutMillis, isSSL));
    }

    @Override
    public void addListener(ILifeCycle listener) {
        this.pool.addListener(listener);
    }

    @Override
    public boolean removeListener(ILifeCycle listener) {
        return this.pool.removeListener(listener);
    }

    @Override
    public int getPooledMaxIdleTimeMillis() {
        return this.pool.getPooledMaxIdleTimeMillis();
    }

    @Override
    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.pool.setPooledMaxIdleTimeMillis(idleTimeoutMillis);
    }

    @Override
    public int getPooledMaxLifeTimeMillis() {
        return this.pool.getPooledMaxLifeTimeMillis();
    }

    @Override
    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.pool.setPooledMaxLifeTimeMillis(lifeTimeoutMillis);
    }

    @Override
    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    @Override
    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    @Override
    public long getCreationMaxWaitMillis() {
        return this.pool.getCreationMaxWaitMillis();
    }

    @Override
    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        this.pool.setCreationMaxWaitMillis(maxWaitMillis);
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public List<String> getActiveConnectionInfos() {
        return this.pool.getActiveConnectionInfos();
    }

    @Override
    public List<String> getIdleConnectionInfos() {
        return this.pool.getIdleConnectionInfos();
    }

    @Override
    public int getNumCreated() {
        return this.pool.getNumCreated();
    }

    @Override
    public int getNumDestroyed() {
        return this.pool.getNumDestroyed();
    }

    public int getNumTimeoutConnectionLifetime() {
        return this.pool.getNumTimeoutConnectionLifetime();
    }

    public int getNumTimeoutConnectionIdle() {
        return this.pool.getNumTimeoutConnectionIdle();
    }

    @Override
    public int getNumTimeoutPooledMaxIdleTime() {
        return this.pool.getNumTimeoutPooledMaxIdleTime();
    }

    @Override
    public int getNumTimeoutPooledMaxLifeTime() {
        return this.pool.getNumTimeoutPooledMaxLifeTime();
    }

    public int getNumPendingGet() {
        return this.pool.getNumPendingGet();
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public void destroy(IBlockingConnection resource) throws IOException {
        if (resource instanceof BlockingConnection) {
            NonBlockingConnectionPool.destroy(((BlockingConnection)resource).getDelegee());
        }
        resource.close();
    }
}

