/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.matchers;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.DifferenceEngineConfigurer;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonController;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.util.Predicate;

public final class CompareMatcher
extends BaseMatcher<Object>
implements DifferenceEngineConfigurer<CompareMatcher> {
    private static final Logger LOGGER = Logger.getLogger(CompareMatcher.class.getName());
    private final DiffBuilder diffBuilder;
    private boolean throwComparisonFailure;
    private ComparisonResult checkFor;
    private Diff diffResult;
    private boolean formatXml;
    private static final ComparisonFormatter DEFAULT_FORMATTER = new DefaultComparisonFormatter();
    private ComparisonFormatter comparisonFormatter = DEFAULT_FORMATTER;
    private static Constructor<?> comparisonFailureConstructor;

    private CompareMatcher(Object control) {
        this.diffBuilder = DiffBuilder.compare((Object)control);
    }

    @Factory
    public static CompareMatcher isIdenticalTo(Object control) {
        return new CompareMatcher(control).checkForIdentical();
    }

    @Factory
    public static CompareMatcher isSimilarTo(Object control) {
        return new CompareMatcher(control).checkForSimilar();
    }

    private CompareMatcher checkForSimilar() {
        this.diffBuilder.checkForSimilar();
        this.checkFor = ComparisonResult.SIMILAR;
        return this;
    }

    private CompareMatcher checkForIdentical() {
        this.diffBuilder.checkForIdentical();
        this.checkFor = ComparisonResult.EQUAL;
        return this;
    }

    public CompareMatcher ignoreWhitespace() {
        this.formatXml = true;
        this.diffBuilder.ignoreWhitespace();
        return this;
    }

    public CompareMatcher normalizeWhitespace() {
        this.formatXml = true;
        this.diffBuilder.normalizeWhitespace();
        return this;
    }

    public CompareMatcher ignoreComments() {
        this.diffBuilder.ignoreComments();
        return this;
    }

    public CompareMatcher ignoreElementContentWhitespace() {
        this.diffBuilder.ignoreElementContentWhitespace();
        return this;
    }

    public CompareMatcher ignoreCommentsUsingXSLTVersion(String xsltVersion) {
        this.diffBuilder.ignoreCommentsUsingXSLTVersion(xsltVersion);
        return this;
    }

    public CompareMatcher withNodeMatcher(NodeMatcher nodeMatcher) {
        this.diffBuilder.withNodeMatcher(nodeMatcher);
        return this;
    }

    public CompareMatcher withDifferenceEvaluator(DifferenceEvaluator differenceEvaluator) {
        this.diffBuilder.withDifferenceEvaluator(differenceEvaluator);
        return this;
    }

    public CompareMatcher withComparisonListeners(ComparisonListener ... comparisonListeners) {
        this.diffBuilder.withComparisonListeners(comparisonListeners);
        return this;
    }

    public CompareMatcher withDifferenceListeners(ComparisonListener ... comparisonListeners) {
        this.diffBuilder.withDifferenceListeners(comparisonListeners);
        return this;
    }

    public CompareMatcher withNamespaceContext(Map<String, String> prefix2Uri) {
        this.diffBuilder.withNamespaceContext(prefix2Uri);
        return this;
    }

    public CompareMatcher withAttributeFilter(Predicate<Attr> attributeFilter) {
        this.diffBuilder.withAttributeFilter(attributeFilter);
        return this;
    }

    public CompareMatcher withNodeFilter(Predicate<Node> nodeFilter) {
        this.diffBuilder.withNodeFilter(nodeFilter);
        return this;
    }

    public CompareMatcher throwComparisonFailure() {
        this.throwComparisonFailure = true;
        return this;
    }

    public CompareMatcher withComparisonFormatter(ComparisonFormatter comparisonFormatter) {
        this.comparisonFormatter = comparisonFormatter;
        return this;
    }

    public CompareMatcher withDocumentBuilderFactory(DocumentBuilderFactory f) {
        this.diffBuilder.withDocumentBuilderFactory(f);
        return this;
    }

    public CompareMatcher withComparisonController(ComparisonController comparisonController) {
        throw new UnsupportedOperationException("Can't set ComparisonController with CompareMatcher");
    }

    public boolean matches(Object item) {
        AssertionError assertionError;
        if (this.checkFor == ComparisonResult.EQUAL) {
            this.diffBuilder.withComparisonController(ComparisonControllers.StopWhenSimilar);
        } else if (this.checkFor == ComparisonResult.SIMILAR) {
            this.diffBuilder.withComparisonController(ComparisonControllers.StopWhenDifferent);
        }
        this.diffResult = this.diffBuilder.withTest(item).build();
        if (!this.diffResult.hasDifferences()) {
            return true;
        }
        if (this.throwComparisonFailure && (assertionError = this.createComparisonFailure()) != null) {
            throw assertionError;
        }
        return false;
    }

    private AssertionError createComparisonFailure() {
        Comparison difference = this.firstComparison();
        String reason = this.createReasonPrefix(this.diffResult.getControlSource().getSystemId(), difference);
        String controlString = this.comparisonFormatter.getDetails(difference.getControlDetails(), difference.getType(), this.formatXml);
        String testString = this.comparisonFormatter.getDetails(difference.getTestDetails(), difference.getType(), this.formatXml);
        return CompareMatcher.createComparisonFailure(reason, controlString, testString);
    }

    private static AssertionError createComparisonFailure(String reason, String controlString, String testString) {
        try {
            if (comparisonFailureConstructor == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> comparisonFailureClass = classLoader.loadClass("org.junit.ComparisonFailure");
                comparisonFailureConstructor = comparisonFailureClass.getConstructor(String.class, String.class, String.class);
            }
            return (AssertionError)comparisonFailureConstructor.newInstance(reason, controlString, testString);
        }
        catch (Exception e) {
            LOGGER.info("Either add junit to your classpath or do not call '.throwComparisonFailure()'. " + e);
            return null;
        }
    }

    public void describeTo(Description description) {
        if (this.diffResult == null || !this.diffResult.hasDifferences()) {
            description.appendText(" is ").appendText(this.checkFor == ComparisonResult.EQUAL ? "equal" : "similar").appendText(" to the control document");
            return;
        }
        Comparison difference = this.firstComparison();
        String reason = this.createReasonPrefix(this.diffResult.getControlSource().getSystemId(), difference);
        String testString = this.comparisonFormatter.getDetails(difference.getControlDetails(), difference.getType(), this.formatXml);
        description.appendText(String.format("%s:%n%s", reason, testString));
    }

    private String createReasonPrefix(String systemId, Comparison difference) {
        String description = this.comparisonFormatter.getDescription(difference);
        String reason = systemId == null ? description : String.format("In Source '%s' %s", systemId, description);
        return reason;
    }

    public void describeMismatch(Object item, Description description) {
        Comparison difference = this.firstComparison();
        String controlString = this.comparisonFormatter.getDetails(difference.getTestDetails(), difference.getType(), this.formatXml);
        description.appendText(String.format("result was: %n%s", controlString));
    }

    private Comparison firstComparison() {
        return ((Difference)this.diffResult.getDifferences().iterator().next()).getComparison();
    }
}

