/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.w3c.dom.Node;
import org.xmlunit.assertj3.AssertionsAdapter;
import org.xmlunit.assertj3.NodeAssertFactory;
import org.xmlunit.assertj3.NodeUtils;
import org.xmlunit.assertj3.SingleNodeAssert;
import org.xmlunit.assertj3.error.ShouldAnyNodeHaveXPath;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.xpath.JAXPXPathEngine;

public class MultipleNodeAssert
extends FactoryBasedNavigableIterableAssert<MultipleNodeAssert, Iterable<Node>, Node, SingleNodeAssert> {
    private MultipleNodeAssert(Iterable<Node> nodes, JAXPXPathEngine engine) {
        super(nodes, MultipleNodeAssert.class, (AssertFactory)new NodeAssertFactory(engine));
    }

    static MultipleNodeAssert create(Object xmlSource, Map<String, String> prefix2Uri, DocumentBuilderFactory dbf, XPathFactory xpf, String xPath) {
        JAXPXPathEngine engine;
        AssertionsAdapter.assertThat(xPath).isNotBlank();
        JAXPXPathEngine jAXPXPathEngine = engine = xpf == null ? new JAXPXPathEngine() : new JAXPXPathEngine(xpf);
        if (prefix2Uri != null) {
            engine.setNamespaceContext(prefix2Uri);
        }
        Source s = Input.from((Object)xmlSource).build();
        Node root = dbf != null ? Convert.toNode((Source)s, (DocumentBuilderFactory)dbf) : Convert.toNode((Source)s);
        Iterable nodes = engine.selectNodes(xPath, root);
        return (MultipleNodeAssert)new MultipleNodeAssert(nodes, engine).describedAs("XPath \"%s\" evaluated to node set", new Object[]{xPath});
    }

    public MultipleNodeAssert exist() {
        return (MultipleNodeAssert)this.isNotEmpty();
    }

    public void doNotExist() {
        this.isEmpty();
    }

    public MultipleNodeAssert haveAttribute(final String attributeName) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasAttribute(attributeName);
            }
        });
        return this;
    }

    public MultipleNodeAssert haveAttribute(final String attributeName, final String attributeValue) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasAttribute(attributeName, attributeValue);
            }
        });
        return this;
    }

    public MultipleNodeAssert doNotHaveAttribute(final String attributeName) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.doesNotHaveAttribute(attributeName);
            }
        });
        return this;
    }

    public MultipleNodeAssert doNotHaveAttribute(final String attributeName, final String attributeValue) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.doesNotHaveAttribute(attributeName, attributeValue);
            }
        });
        return this;
    }

    public MultipleNodeAssert containsAnyNodeHavingXPath(String xPath) {
        this.isNotNull();
        int index = 0;
        for (Node node : (Iterable)this.actual) {
            SingleNodeAssert singleNodeAssert = (SingleNodeAssert)this.toAssert(node, this.navigationDescription("check node at index " + index));
            if (!singleNodeAssert.isNodeSetEmpty(xPath)) {
                return this;
            }
            ++index;
        }
        this.throwAssertionError(ShouldAnyNodeHaveXPath.shouldAnyNodeHaveXPath(xPath));
        return null;
    }

    public MultipleNodeAssert containsAllNodesHavingXPath(final String xPath) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasXPath(xPath);
            }
        });
        return this;
    }

    public AbstractListAssert<?, List<? extends String>, String, ObjectAssert<String>> extractingAttribute(String attribute) {
        this.isNotNull();
        ArrayList<String> values = new ArrayList<String>();
        for (Node node : (Iterable)this.actual) {
            values.add(NodeUtils.attributeValue(node, attribute));
        }
        String extractedDescription = String.format("Extracted attribute: %s", attribute);
        String description = Description.mostRelevantDescription((Description)this.info.description(), (String)extractedDescription);
        return this.newListAssertInstance(values).as(description, new Object[0]);
    }

    public AbstractListAssert<?, List<? extends String>, String, ObjectAssert<String>> extractingText() {
        this.isNotNull();
        ArrayList<String> values = new ArrayList<String>();
        for (Node node : (Iterable)this.actual) {
            String textContent = node.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            values.add(textContent);
        }
        String extractedDescription = "Extracted text content";
        String description = Description.mostRelevantDescription((Description)this.info.description(), (String)extractedDescription);
        return this.newListAssertInstance(values).as(description, new Object[0]);
    }

    private void allSatisfy(SingleNodeAssertConsumer consumer) {
        int index = 0;
        for (Node node : (Iterable)this.actual) {
            SingleNodeAssert singleNodeAssert = (SingleNodeAssert)this.toAssert(node, this.navigationDescription("check node at index " + index));
            consumer.accept(singleNodeAssert);
            ++index;
        }
    }

    static interface SingleNodeAssertConsumer {
        public void accept(SingleNodeAssert var1);
    }
}

