/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.ArrayList;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Lists;

abstract class CustomAbstractAssert<SELF extends CustomAbstractAssert<SELF, ACTUAL>, ACTUAL>
extends AbstractAssert<SELF, ACTUAL> {
    private static final String ORG_XMLUNIT_ASSERTJ_ERROR = "org.xmlunit.assertj.error";

    CustomAbstractAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    void throwAssertionError(AssertionErrorFactory assertionErrorFactory) {
        AssertionError assertionError = assertionErrorFactory.newAssertionError(this.info.description(), this.info.representation());
        Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
        this.removeCustomAssertRelatedElementsFromStackTraceIfNeeded(assertionError);
        throw assertionError;
    }

    private void removeCustomAssertRelatedElementsFromStackTraceIfNeeded(AssertionError assertionError) {
        if (!Failures.instance().isRemoveAssertJRelatedElementsFromStackTrace()) {
            return;
        }
        ArrayList filtered = Lists.newArrayList((Object[])((Throwable)((Object)assertionError)).getStackTrace());
        for (StackTraceElement element : ((Throwable)((Object)assertionError)).getStackTrace()) {
            if (!this.isElementOfCustomAssert(element)) continue;
            filtered.remove(element);
        }
        StackTraceElement[] newStackTrace = filtered.toArray(new StackTraceElement[0]);
        ((Throwable)((Object)assertionError)).setStackTrace(newStackTrace);
    }

    private boolean isElementOfCustomAssert(StackTraceElement stackTraceElement) {
        for (Class<?> currentAssertClass = ((Object)((Object)this)).getClass(); currentAssertClass != AbstractAssert.class; currentAssertClass = currentAssertClass.getSuperclass()) {
            if (stackTraceElement.getClassName().equals(currentAssertClass.getName())) {
                return true;
            }
            if (!stackTraceElement.getClassName().contains(ORG_XMLUNIT_ASSERTJ_ERROR)) continue;
            return true;
        }
        return false;
    }
}

