/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xmlbeam.AutoMap;
import org.xmlbeam.DefaultFileMap;
import org.xmlbeam.DefaultXPathBinder;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.CanEvaluate;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.evaluation.XPathBinder;
import org.xmlbeam.evaluation.XPathEvaluator;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.io.FileIO;
import org.xmlbeam.io.StreamOutput;
import org.xmlbeam.types.CloseableMap;
import org.xmlbeam.types.XBAutoMap;
import org.xmlbeam.util.IOHelper;
import org.xmlbeam.util.intern.DOMHelper;

class DefaultFileIO
implements CanEvaluate,
FileIO {
    private final XBProjector projector;
    private boolean append = false;
    private boolean failIfNotExists = false;
    private final File file;

    public DefaultFileIO(XBProjector xmlProjector, File file) {
        if (xmlProjector == null) {
            throw new NullPointerException("Parameter xmlProjector must not be null.");
        }
        if (file == null) {
            throw new NullPointerException("Parameter file must not be null.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File " + file + " is a directory.");
        }
        this.projector = xmlProjector;
        this.file = file;
    }

    public DefaultFileIO(XBProjector xmlProjector, String fileName) {
        this(xmlProjector, new File(fileName));
    }

    @Override
    public <T> T read(Class<T> projectionInterface) throws IOException {
        try {
            Document document = this.projector.config().createDocumentBuilder().parse(this.file);
            return this.projector.projectDOMNode(document, projectionInterface);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Object projection) throws IOException {
        FileOutputStream os = new FileOutputStream(this.file, this.append);
        new StreamOutput(this.projector, os).write(projection);
        os.close();
    }

    @Override
    public FileIO setAppend(boolean ... append) {
        this.append = append != null && (append.length == 0 || append.length > 0 && append[0]);
        return this;
    }

    @Override
    public FileIO failIfNotExists(boolean ... failOnFNF) {
        this.failIfNotExists = failOnFNF != null && (failOnFNF.length == 0 || failOnFNF.length > 0 && failOnFNF[0]);
        return this;
    }

    @Override
    public XPathEvaluator evalXPath(String xpath) {
        return new DefaultXPathEvaluator(this.projector, new DocumentResolver(){

            @Override
            public Document resolve(Class<?> ... resourceAwareClass) throws IOException {
                FileInputStream fileInputStream = new FileInputStream(DefaultFileIO.this.file);
                Document doc = IOHelper.loadDocument(DefaultFileIO.this.projector, fileInputStream);
                fileInputStream.close();
                return doc;
            }
        }, xpath);
    }

    @Override
    public XPathBinder bindXPath(String xpath) {
        final Document[] doc = new Document[1];
        return new DefaultXPathBinder(this.projector, new DocumentResolver(){

            @Override
            public Document resolve(Class<?> ... resourceAwareClass) throws IOException {
                if (DefaultFileIO.this.file.isFile()) {
                    FileInputStream fileInputStream = new FileInputStream(DefaultFileIO.this.file);
                    doc[0] = IOHelper.loadDocument(DefaultFileIO.this.projector, fileInputStream);
                    fileInputStream.close();
                } else {
                    if (DefaultFileIO.this.failIfNotExists) {
                        throw new FileNotFoundException(DefaultFileIO.this.file.getAbsolutePath());
                    }
                    doc[0] = DefaultFileIO.this.projector.config().createDocumentBuilder().newDocument();
                }
                return doc[0];
            }
        }, xpath, new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    FileOutputStream fileOutPutStream = new FileOutputStream(DefaultFileIO.this.file);
                    DOMHelper.trim(doc[0]);
                    DefaultFileIO.this.projector.config().createTransformer(new Document[0]).transform(new DOMSource(doc[0]), new StreamResult(fileOutPutStream));
                    fileOutPutStream.flush();
                    fileOutPutStream.close();
                }
                catch (TransformerException e) {
                    throw new XBException("Could not write to file " + DefaultFileIO.this.file.getAbsolutePath(), e);
                }
            }
        });
    }

    @Override
    public <T> CloseableMap<T> bindAsMapOf(Class<T> valueType) throws IOException {
        DefaultXPathBinder.validateEvaluationType(valueType);
        if (this.failIfNotExists && !this.file.exists()) {
            throw new FileNotFoundException(this.file.getAbsolutePath());
        }
        final Document[] document = new Document[1];
        try {
            document[0] = this.file.exists() ? this.projector.config().createDocumentBuilder().parse(this.file) : this.projector.config().createDocumentBuilder().newDocument();
            InvocationContext invocationContext = new InvocationContext(null, null, null, null, null, valueType, this.projector);
            return new DefaultFileMap(document[0], invocationContext, new Closeable(){
                final Document doc;
                {
                    this.doc = document[0];
                }

                @Override
                public void close() throws IOException {
                    try {
                        FileOutputStream fileOutPutStream = new FileOutputStream(DefaultFileIO.this.file);
                        DOMHelper.trim(this.doc);
                        DefaultFileIO.this.projector.config().createTransformer(new Document[0]).transform(new DOMSource(this.doc), new StreamResult(fileOutPutStream));
                        fileOutPutStream.flush();
                        fileOutPutStream.close();
                    }
                    catch (TransformerException e) {
                        throw new XBException("Could not write to file " + DefaultFileIO.this.file.getAbsolutePath(), e);
                    }
                }
            }, valueType);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> XBAutoMap<T> readAsMapOf(Class<T> valueType) throws IOException {
        DefaultXPathBinder.validateEvaluationType(valueType);
        try {
            Document document = this.projector.config().createDocumentBuilder().parse(this.file);
            InvocationContext invocationContext = new InvocationContext(null, null, null, null, null, valueType, this.projector);
            return new AutoMap(document, invocationContext, valueType);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

