/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.xipki.common.util.ParamUtil;

public class CmpFailureUtil {
    private static final Map<Integer, String> STATUS_TEXT_MAP = new HashMap<Integer, String>();
    private static final String[] FAILUREINFO_TEXTS = new String[]{"incorrectData", "wrongAuthority", "badDataFormat", "badCertId", "badTime", "badRequest", "badMessageCheck", "badAlg", "unacceptedPolicy", "timeNotAvailable", "badRecipientNonce", "wrongIntegrity", "certConfirmed", "certRevoked", "badPOP", "missingTimeStamp", "notAuthorized", "unsupportedVersion", "transactionIdInUse", "signerNotTrusted", "badCertTemplate", "badSenderNonce", "addInfoNotAvailable", "unacceptedExtension", "-", "-", "-", "-", "-", "duplicateCertReq", "systemFailure", "systemUnavail"};

    private CmpFailureUtil() {
    }

    public static String formatPkiStatusInfo(PKIStatusInfo pkiStatusInfo) {
        ParamUtil.requireNonNull((String)"pkiStatusInfo", (Object)pkiStatusInfo);
        int status = pkiStatusInfo.getStatus().intValue();
        int failureInfo = pkiStatusInfo.getFailInfo().intValue();
        PKIFreeText text = pkiStatusInfo.getStatusString();
        String statusMessage = text == null ? null : text.getStringAt(0).getString();
        return CmpFailureUtil.formatPkiStatusInfo(status, failureInfo, statusMessage);
    }

    public static String formatPkiStatusInfo(int status, int failureInfo, String statusMessage) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("PKIStatusInfo {status = ").append(status);
        sb.append(" (").append(STATUS_TEXT_MAP.get(status)).append("), ");
        sb.append("failureInfo = ").append(failureInfo);
        sb.append(" (").append(CmpFailureUtil.getFailureInfoText(failureInfo)).append("), ");
        sb.append("statusMessage = ").append(statusMessage).append("}");
        return sb.toString();
    }

    public static String getFailureInfoText(int failureInfo) {
        BigInteger bi = BigInteger.valueOf(failureInfo);
        int n = Math.min(bi.bitLength(), FAILUREINFO_TEXTS.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (!bi.testBit(i)) continue;
            sb.append(", ").append(FAILUREINFO_TEXTS[i]);
        }
        return sb.length() < 3 ? "" : sb.substring(2);
    }

    static {
        STATUS_TEXT_MAP.put(-2, "xipki_noAnswer");
        STATUS_TEXT_MAP.put(-1, "xipki_responseError");
        STATUS_TEXT_MAP.put(0, "accepted");
        STATUS_TEXT_MAP.put(1, "grantedWithMods");
        STATUS_TEXT_MAP.put(2, "rejection");
        STATUS_TEXT_MAP.put(3, "waiting");
        STATUS_TEXT_MAP.put(4, "revocationWarning");
        STATUS_TEXT_MAP.put(5, "revocationNotification");
        STATUS_TEXT_MAP.put(6, "keyUpdateWarning");
    }
}

