/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DefaultConcurrentContentSigner;
import org.xipki.security.HashAlgoType;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs12.AESGmacContentSigner;
import org.xipki.security.pkcs12.HmacContentSigner;
import org.xipki.security.util.KeyUtil;

public class SoftTokenMacContentSignerBuilder {
    private final SecretKey key;

    public SoftTokenMacContentSignerBuilder(SecretKey key) throws XiSecurityException {
        this.key = (SecretKey)ParamUtil.requireNonNull((String)"key", (Object)key);
    }

    public SoftTokenMacContentSignerBuilder(String keystoreType, InputStream keystoreStream, char[] keystorePassword, String keyname, char[] keyPassword) throws XiSecurityException {
        if (!"JCEKS".equalsIgnoreCase(keystoreType)) {
            throw new IllegalArgumentException("unsupported keystore type: " + keystoreType);
        }
        ParamUtil.requireNonNull((String)"keystoreStream", (Object)keystoreStream);
        ParamUtil.requireNonNull((String)"keystorePassword", (Object)keystorePassword);
        ParamUtil.requireNonNull((String)"keyPassword", (Object)keyPassword);
        try {
            KeyStore ks = KeyUtil.getKeyStore(keystoreType);
            ks.load(keystoreStream, keystorePassword);
            String tmpKeyname = keyname;
            if (tmpKeyname == null) {
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!ks.isKeyEntry(alias)) continue;
                    tmpKeyname = alias;
                    break;
                }
            } else if (!ks.isKeyEntry(tmpKeyname)) {
                throw new XiSecurityException("unknown key named " + tmpKeyname);
            }
            this.key = (SecretKey)ks.getKey(tmpKeyname, keyPassword);
        }
        catch (IOException | ClassCastException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism, SecureRandom random) throws XiSecurityException {
        DefaultConcurrentContentSigner concurrentSigner;
        ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        boolean gmac = false;
        ASN1ObjectIdentifier oid = signatureAlgId.getAlgorithm();
        if (oid.equals((Object)NISTObjectIdentifiers.id_aes128_GCM) || oid.equals((Object)NISTObjectIdentifiers.id_aes192_GCM) || oid.equals((Object)NISTObjectIdentifiers.id_aes256_GCM)) {
            gmac = true;
        }
        for (int i = 0; i < parallelism; ++i) {
            XiContentSigner signer = gmac ? new AESGmacContentSigner(oid, this.key) : new HmacContentSigner(signatureAlgId, this.key);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DefaultConcurrentContentSigner(true, signers, this.key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        concurrentSigner.setSha1DigestOfMacKey(HashAlgoType.SHA1.hash(this.key.getEncoded()));
        return concurrentSigner;
    }

    public SecretKey key() {
        return this.key;
    }
}

