/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1RemoveObjectsParams
extends ASN1Object {
    private final P11SlotIdentifier slotId;
    private final byte[] objectId;
    private final String objectLabel;

    public Asn1RemoveObjectsParams(P11SlotIdentifier slotId, byte[] objectId, String objectLabel) {
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        if ((objectId == null || objectId.length == 0) && StringUtil.isBlank((String)objectLabel)) {
            throw new IllegalArgumentException("at least one of objectId and objectLabel must not be null");
        }
        this.objectId = objectId;
        this.objectLabel = objectLabel;
        this.slotId = slotId;
    }

    private Asn1RemoveObjectsParams(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 2, 3);
        int idx = 0;
        this.slotId = Asn1P11SlotIdentifier.getInstance(seq.getObjectAt(idx++)).slotId();
        int size = seq.size();
        ASN1Encodable asn1Id = null;
        ASN1Encodable asn1Label = null;
        if (size == 2) {
            ASN1Encodable asn1 = seq.getObjectAt(1);
            if (asn1 instanceof ASN1String) {
                asn1Label = asn1;
            } else {
                asn1Id = asn1;
            }
        } else {
            asn1Id = seq.getObjectAt(idx++);
            asn1Label = seq.getObjectAt(idx++);
        }
        this.objectId = asn1Id == null ? null : Asn1Util.getOctetStringBytes(asn1Id);
        String string = this.objectLabel = asn1Label == null ? null : Asn1Util.getUtf8String(seq.getObjectAt(idx++));
        if ((this.objectId == null || this.objectId.length == 0) && StringUtil.isBlank((String)this.objectLabel)) {
            throw new BadAsn1ObjectException("invalid object Asn1RemoveObjectsParams: at least one of id and label must not be null");
        }
    }

    public static Asn1RemoveObjectsParams getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1RemoveObjectsParams) {
            return (Asn1RemoveObjectsParams)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1RemoveObjectsParams((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1RemoveObjectsParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new Asn1P11SlotIdentifier(this.slotId));
        vector.add((ASN1Encodable)new DERUTF8String(this.objectLabel));
        return new DERSequence(vector);
    }

    public P11SlotIdentifier slotId() {
        return this.slotId;
    }

    public byte[] ojectId() {
        return Arrays.copyOf(this.objectId, this.objectId.length);
    }

    public String objectLabel() {
        return this.objectLabel;
    }
}

