/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11ObjectIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1P11EntityIdentifier
extends ASN1Object {
    private final Asn1P11SlotIdentifier slotId;
    private final Asn1P11ObjectIdentifier objectId;
    private final P11EntityIdentifier entityId;

    public Asn1P11EntityIdentifier(P11SlotIdentifier slotId, P11ObjectIdentifier objectId) {
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        this.slotId = new Asn1P11SlotIdentifier(slotId);
        this.objectId = new Asn1P11ObjectIdentifier(objectId);
        this.entityId = new P11EntityIdentifier(slotId, objectId);
    }

    public Asn1P11EntityIdentifier(Asn1P11SlotIdentifier slotId, Asn1P11ObjectIdentifier objectId) {
        this.slotId = (Asn1P11SlotIdentifier)((Object)ParamUtil.requireNonNull((String)"slotId", (Object)((Object)slotId)));
        this.objectId = (Asn1P11ObjectIdentifier)((Object)ParamUtil.requireNonNull((String)"objectId", (Object)((Object)objectId)));
        this.entityId = new P11EntityIdentifier(slotId.slotId(), objectId.objectId());
    }

    public Asn1P11EntityIdentifier(P11EntityIdentifier entityId) {
        this.entityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"entityId", (Object)entityId);
        this.slotId = new Asn1P11SlotIdentifier(entityId.slotId());
        this.objectId = new Asn1P11ObjectIdentifier(entityId.objectId());
    }

    private Asn1P11EntityIdentifier(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 2, 2);
        int idx = 0;
        this.slotId = Asn1P11SlotIdentifier.getInstance(seq.getObjectAt(idx++));
        this.objectId = Asn1P11ObjectIdentifier.getInstance(seq.getObjectAt(idx++));
        this.entityId = new P11EntityIdentifier(this.slotId.slotId(), this.objectId.objectId());
    }

    public static Asn1P11EntityIdentifier getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1P11EntityIdentifier) {
            return (Asn1P11EntityIdentifier)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1P11EntityIdentifier((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1P11EntityIdentifier.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.slotId);
        vector.add((ASN1Encodable)this.objectId);
        return new DERSequence(vector);
    }

    public Asn1P11SlotIdentifier slotId() {
        return this.slotId;
    }

    public Asn1P11ObjectIdentifier objectId() {
        return this.objectId;
    }

    public P11EntityIdentifier entityId() {
        return this.entityId;
    }
}

