/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11EntityIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1EntityIdAndCert
extends ASN1Object {
    private final Asn1P11EntityIdentifier entityId;
    private final Certificate certificate;

    public Asn1EntityIdAndCert(Asn1P11EntityIdentifier entityId, Certificate certificate) {
        this.entityId = (Asn1P11EntityIdentifier)((Object)ParamUtil.requireNonNull((String)"entityId", (Object)((Object)entityId)));
        this.certificate = (Certificate)ParamUtil.requireNonNull((String)"certificate", (Object)certificate);
    }

    public Asn1EntityIdAndCert(P11EntityIdentifier entityId, X509Certificate certificate) {
        byte[] encoded;
        ParamUtil.requireNonNull((String)"entityId", (Object)entityId);
        ParamUtil.requireNonNull((String)"certificate", (Object)certificate);
        this.entityId = new Asn1P11EntityIdentifier(entityId);
        try {
            encoded = certificate.getEncoded();
        }
        catch (CertificateEncodingException ex) {
            throw new IllegalArgumentException("could not encode certificate: " + ex.getMessage(), ex);
        }
        this.certificate = Certificate.getInstance((Object)encoded);
    }

    private Asn1EntityIdAndCert(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 2, 2);
        int idx = 0;
        this.entityId = Asn1P11EntityIdentifier.getInstance(seq.getObjectAt(idx++));
        this.certificate = Asn1Util.getCertificate(seq.getObjectAt(idx++));
    }

    public static Asn1EntityIdAndCert getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1EntityIdAndCert) {
            return (Asn1EntityIdAndCert)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1EntityIdAndCert((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1EntityIdAndCert.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.entityId);
        vector.add((ASN1Encodable)this.certificate);
        return new DERSequence(vector);
    }

    public Asn1P11EntityIdentifier entityId() {
        return this.entityId;
    }

    public Certificate certificate() {
        return this.certificate;
    }
}

