/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.proxy.ProxyP11Slot;
import org.xipki.security.pkcs11.proxy.msg.Asn1DigestSecretKeyTemplate;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11EntityIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11Params;
import org.xipki.security.pkcs11.proxy.msg.Asn1RSAPkcsPssParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1SignTemplate;

class ProxyP11Identity
extends P11Identity {
    ProxyP11Identity(P11Slot slot, P11EntityIdentifier entityId) {
        super(slot, entityId, 0);
    }

    ProxyP11Identity(P11Slot slot, P11EntityIdentifier entityId, PublicKey publicKey, X509Certificate[] certificateChain) {
        super(slot, entityId, publicKey, certificateChain);
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        ASN1OctetString octetString;
        Asn1P11EntityIdentifier asn1EntityId = new Asn1P11EntityIdentifier(this.identityId);
        Asn1P11Params p11Param = null;
        if (parameters instanceof P11RSAPkcsPssParams) {
            p11Param = new Asn1P11Params((ASN1Encodable)new Asn1RSAPkcsPssParams((P11RSAPkcsPssParams)parameters));
        }
        Asn1SignTemplate signTemplate = new Asn1SignTemplate(asn1EntityId, mechanism, p11Param, content);
        byte[] result = ((ProxyP11Slot)this.slot).module().send((short)288, signTemplate);
        try {
            octetString = DEROctetString.getInstance((Object)result);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("the returned result is not OCTET STRING");
        }
        return octetString == null ? null : octetString.getOctets();
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws P11TokenException {
        ASN1OctetString octetString;
        Asn1P11EntityIdentifier asn1EntityId = new Asn1P11EntityIdentifier(this.identityId);
        Asn1DigestSecretKeyTemplate template = new Asn1DigestSecretKeyTemplate(asn1EntityId, mechanism);
        byte[] result = ((ProxyP11Slot)this.slot).module().send((short)308, template);
        try {
            octetString = DEROctetString.getInstance((Object)result);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("the returned result is not OCTET STRING");
        }
        return octetString == null ? null : octetString.getOctets();
    }
}

